/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cloning;

import io.apicurio.datamodels.cloning.ModelClonerVisitor;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasXML;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Headers;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Scopes;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;

public class Oas20ModelClonerVisitor
extends ModelClonerVisitor
implements IOas20Visitor {
    @Override
    public void visitPaths(OasPaths node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths();
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem(node.getPath());
    }

    @Override
    public void visitResponse(OasResponse node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createResponses().createResponse(node.getStatusCode());
    }

    @Override
    public void visitResponses(OasResponses node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createResponses();
    }

    @Override
    public void visitXML(OasXML node) {
        this.clone = ((OasSchema)((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createParameter().createSchema()).createXML();
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        this.clone = node.createAllOfSchema();
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        this.clone = ((OasSchema)((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createParameter().createSchema()).createItemsSchema();
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.clone = ((OasSchema)((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createParameter().createSchema()).createAdditionalPropertiesSchema();
    }

    @Override
    public void visitPropertySchema(IPropertySchema node) {
        this.clone = ((OasSchema)((OasDocument)((Node)((Object)node)).ownerDocument()).createPaths().createPathItem("").createOperation(null).createParameter().createSchema()).createPropertySchema(node.getPropertyName());
    }

    @Override
    public void visitHeader(OasHeader node) {
        this.clone = ((Oas20Response)((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(null).createResponses().createDefaultResponse()).createHeaders().createHeader(node.getName());
    }

    @Override
    public void visitResponseDefinition(IDefinition node) {
        this.clone = ((Oas20Document)((Node)((Object)node)).ownerDocument()).createResponseDefinitions().createResponse(node.getName());
    }

    @Override
    public void visitExample(IExample node) {
        this.clone = ((Oas20Document)((Node)((Object)node)).ownerDocument()).createResponseDefinitions().createResponse("").createExample();
    }

    @Override
    public void visitOperation(Operation node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createOperation(node.getType());
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.clone = ((Oas20Document)((Node)((Object)node)).ownerDocument()).createParameterDefinitions().createParameter(node.getName());
    }

    @Override
    public void visitParameter(Parameter node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createParameter();
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.clone = ((Oas20Document)((Node)((Object)node)).ownerDocument()).createDefinitions().createSchemaDefinition(node.getName());
    }

    @Override
    public void visitSchema(Schema node) {
        this.clone = ((OasDocument)node.ownerDocument()).createPaths().createPathItem("").createParameter().createSchema();
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        this.clone = ((OasDocument)node.ownerDocument()).createSecurityRequirement();
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createSecurityDefinitions().createSecurityScheme(node.getName());
    }

    @Override
    public void visitItems(Oas20Items node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createDefinitions().createSchemaDefinition("").createItemsSchema();
    }

    @Override
    public void visitScopes(Oas20Scopes node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createSecurityDefinitions().createSecurityScheme("").createScopes();
    }

    @Override
    public void visitSecurityDefinitions(Oas20SecurityDefinitions node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createSecurityDefinitions();
    }

    @Override
    public void visitDefinitions(Oas20Definitions node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createDefinitions();
    }

    @Override
    public void visitParameterDefinitions(Oas20ParameterDefinitions node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createParameterDefinitions();
    }

    @Override
    public void visitHeaders(Oas20Headers node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createResponseDefinitions().createResponse("").createHeaders();
    }

    @Override
    public void visitResponseDefinitions(Oas20ResponseDefinitions node) {
        this.clone = ((Oas20Document)node.ownerDocument()).createResponseDefinitions();
    }
}

