/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllOperationsCommand_Aai20
extends AbstractCommand {
    private static final String[] ALL_TYPES = new String[]{"publish", "subscribe"};
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldOperations;

    DeleteAllOperationsCommand_Aai20() {
    }

    DeleteAllOperationsCommand_Aai20(AaiChannelItem parent) {
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllOperationsCommand_Aai20] Executing.", new Object[0]);
        this._oldOperations = new ArrayList<Object>();
        AaiChannelItem parentChannel = (AaiChannelItem)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parentChannel)) {
            return;
        }
        for (String operationType : ALL_TYPES) {
            AaiOperation oldOp = (AaiOperation)NodeCompat.getProperty(parentChannel, operationType);
            if (this.isNullOrUndefined(oldOp)) continue;
            ObjectNode oldOpData = JsonCompat.objectNode();
            JsonCompat.setPropertyString(oldOpData, "_type", operationType);
            JsonCompat.setProperty(oldOpData, "_operation", Library.writeNode(oldOp));
            this._oldOperations.add(oldOpData);
            NodeCompat.setProperty(parentChannel, operationType, null);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllOperationsCommand_Aai20] Reverting.", new Object[0]);
        if (this._oldOperations == null || this._oldOperations.size() == 0) {
            return;
        }
        AaiChannelItem parentChannel = (AaiChannelItem)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parentChannel)) {
            return;
        }
        Aai20NodeFactory nodeFactory = new Aai20NodeFactory();
        for (Object oldOperationData : this._oldOperations) {
            String operationType = JsonCompat.getPropertyString(oldOperationData, "_type");
            AaiOperation operation = nodeFactory.createOperation(parentChannel, operationType);
            Library.readNode(JsonCompat.getProperty(oldOperationData, "_operation"), operation);
            NodeCompat.setProperty(parentChannel, operationType, operation);
        }
    }
}

