/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.io;

import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.io.OasDataModelReader;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30Components;
import io.apicurio.datamodels.openapi.v3.models.Oas30Discriminator;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Encoding;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExampleDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30ParameterDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30PathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBodyDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30ResponseDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.util.ArrayList;
import java.util.List;

public class Oas30DataModelReader
extends OasDataModelReader {
    @Override
    public void readDocument(Object json, Document node) {
        Oas30Document doc = (Oas30Document)node;
        String openapi = JsonCompat.consumePropertyString(json, "openapi");
        List<Object> servers = JsonCompat.consumePropertyArray(json, "servers");
        Object components = JsonCompat.consumeProperty(json, "components");
        doc.openapi = openapi;
        if (servers != null) {
            ArrayList<Server> serverModels = new ArrayList<Server>();
            servers.forEach(server -> {
                Server serverModel = doc.createServer();
                this.readServer(server, serverModel);
                serverModels.add(serverModel);
            });
            doc.servers = serverModels;
        }
        if (components != null) {
            doc.components = doc.createComponents();
            this.readComponents(components, doc.components);
        }
        super.readDocument(json, doc);
    }

    public void readComponents(Object json, Oas30Components node) {
        Object schemas = JsonCompat.consumeProperty(json, "schemas");
        Object responses = JsonCompat.consumeProperty(json, "responses");
        Object parameters = JsonCompat.consumeProperty(json, "parameters");
        Object examples = JsonCompat.consumeProperty(json, "examples");
        Object requestBodies = JsonCompat.consumeProperty(json, "requestBodies");
        Object headers = JsonCompat.consumeProperty(json, "headers");
        Object securitySchemes = JsonCompat.consumeProperty(json, "securitySchemes");
        Object links = JsonCompat.consumeProperty(json, "links");
        Object callbacks = JsonCompat.consumeProperty(json, "callbacks");
        if (schemas != null) {
            JsonCompat.keys(schemas).forEach(name -> {
                Object schema = JsonCompat.consumeProperty(schemas, name);
                Oas30SchemaDefinition schemaModel = node.createSchemaDefinition((String)name);
                this.readSchema(schema, schemaModel);
                node.addSchemaDefinition((String)name, schemaModel);
            });
        }
        if (responses != null) {
            JsonCompat.keys(responses).forEach(name -> {
                Object response = JsonCompat.consumeProperty(responses, name);
                Oas30ResponseDefinition responseModel = node.createResponseDefinition((String)name);
                this.readResponse(response, responseModel);
                node.addResponseDefinition((String)name, responseModel);
            });
        }
        if (parameters != null) {
            JsonCompat.keys(parameters).forEach(name -> {
                Object parameter = JsonCompat.consumeProperty(parameters, name);
                Oas30ParameterDefinition parameterModel = node.createParameterDefinition((String)name);
                this.readParameter(parameter, parameterModel);
                node.addParameterDefinition((String)name, parameterModel);
            });
        }
        if (examples != null) {
            JsonCompat.keys(examples).forEach(name -> {
                Object example = JsonCompat.consumeProperty(examples, name);
                Oas30ExampleDefinition exampleModel = node.createExampleDefinition((String)name);
                this.readExample(example, exampleModel);
                node.addExampleDefinition((String)name, exampleModel);
            });
        }
        if (requestBodies != null) {
            JsonCompat.keys(requestBodies).forEach(name -> {
                Object requestBody = JsonCompat.consumeProperty(requestBodies, name);
                Oas30RequestBodyDefinition requestBodyModel = node.createRequestBodyDefinition((String)name);
                this.readRequestBody(requestBody, requestBodyModel);
                node.addRequestBodyDefinition((String)name, requestBodyModel);
            });
        }
        if (headers != null) {
            JsonCompat.keys(headers).forEach(name -> {
                Object header = JsonCompat.consumeProperty(headers, name);
                Oas30HeaderDefinition headerModel = node.createHeaderDefinition((String)name);
                this.readHeader(header, headerModel);
                node.addHeaderDefinition((String)name, headerModel);
            });
        }
        if (securitySchemes != null) {
            JsonCompat.keys(securitySchemes).forEach(name -> {
                Object securityScheme = JsonCompat.consumeProperty(securitySchemes, name);
                Oas30SecurityScheme securitySchemeModel = node.createSecurityScheme((String)name);
                this.readSecurityScheme(securityScheme, securitySchemeModel);
                node.addSecurityScheme((String)name, securitySchemeModel);
            });
        }
        if (links != null) {
            JsonCompat.keys(links).forEach(name -> {
                Object link = JsonCompat.consumeProperty(links, name);
                Oas30LinkDefinition linkModel = node.createLinkDefinition((String)name);
                this.readLink(link, linkModel);
                node.addLinkDefinition((String)name, linkModel);
            });
        }
        if (callbacks != null) {
            JsonCompat.keys(callbacks).forEach(name -> {
                Object callback = JsonCompat.consumeProperty(callbacks, name);
                Oas30CallbackDefinition callbackModel = node.createCallbackDefinition((String)name);
                this.readCallback(callback, callbackModel);
                node.addCallbackDefinition((String)name, callbackModel);
            });
        }
    }

    @Override
    public void readSecurityScheme(Object json, SecurityScheme node) {
        Oas30SecurityScheme oasNode = (Oas30SecurityScheme)node;
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String scheme = JsonCompat.consumePropertyString(json, "scheme");
        String bearerFormat = JsonCompat.consumePropertyString(json, "bearerFormat");
        Object flows = JsonCompat.consumeProperty(json, "flows");
        String openIdConnectUrl = JsonCompat.consumePropertyString(json, "openIdConnectUrl");
        oasNode.$ref = $ref;
        oasNode.scheme = scheme;
        oasNode.bearerFormat = bearerFormat;
        oasNode.openIdConnectUrl = openIdConnectUrl;
        if (flows != null) {
            oasNode.flows = oasNode.createOAuthFlows();
            this.readOAuthFlows(flows, oasNode.flows);
        }
        super.readSecurityScheme(json, oasNode);
    }

    @Override
    public void readPathItem(Object json, OasPathItem node) {
        Oas30PathItem pi = (Oas30PathItem)node;
        String summary = JsonCompat.consumePropertyString(json, "summary");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object trace = JsonCompat.consumeProperty(json, "trace");
        List<Object> servers = JsonCompat.consumePropertyArray(json, "servers");
        pi.summary = summary;
        pi.description = description;
        if (trace != null) {
            pi.trace = (Oas30Operation)pi.createOperation("trace");
            this.readOperation(trace, pi.trace);
        }
        if (servers != null) {
            servers.forEach(server -> {
                Oas30Server serverModel = (Oas30Server)pi.createServer();
                this.readServer(server, serverModel);
                pi.addServer(serverModel);
            });
        }
        super.readPathItem(json, node);
    }

    @Override
    public void readHeader(Object json, OasHeader node) {
        Oas30Header header = (Oas30Header)node;
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        Boolean required = JsonCompat.consumePropertyBoolean(json, "required");
        Object schema = JsonCompat.consumeProperty(json, "schema");
        Boolean allowEmptyValue = JsonCompat.consumePropertyBoolean(json, "allowEmptyValue");
        Boolean deprecated = JsonCompat.consumePropertyBoolean(json, "deprecated");
        String style = JsonCompat.consumePropertyString(json, "style");
        Boolean explode = JsonCompat.consumePropertyBoolean(json, "explode");
        Boolean allowReserved = JsonCompat.consumePropertyBoolean(json, "allowReserved");
        Object example = JsonCompat.consumeProperty(json, "example");
        Object examples = JsonCompat.consumeProperty(json, "examples");
        Object content = JsonCompat.consumeProperty(json, "content");
        header.$ref = $ref;
        header.required = required;
        header.allowEmptyValue = allowEmptyValue;
        header.deprecated = deprecated;
        header.style = style;
        header.explode = explode;
        header.allowReserved = allowReserved;
        header.example = example;
        if (schema != null) {
            header.schema = header.createSchema();
            this.readSchema(schema, header.schema);
        }
        if (examples != null) {
            JsonCompat.keys(examples).forEach(name -> {
                Object exx = JsonCompat.consumeProperty(examples, name);
                Oas30Example exampleModel = header.createExample((String)name);
                this.readExample(exx, exampleModel);
                header.addExample(exampleModel);
            });
        }
        if (content != null) {
            JsonCompat.keys(content).forEach(name -> {
                Object mediaType = JsonCompat.consumeProperty(content, name);
                Oas30MediaType mediaTypeModel = header.createMediaType((String)name);
                this.readMediaType(mediaType, mediaTypeModel);
                header.addMediaType((String)name, mediaTypeModel);
            });
        }
        super.readHeader(json, node);
    }

    @Override
    public void readParameter(Object json, Parameter node) {
        Oas30Parameter param = (Oas30Parameter)node;
        Boolean deprecated = JsonCompat.consumePropertyBoolean(json, "deprecated");
        String style = JsonCompat.consumePropertyString(json, "style");
        Boolean explode = JsonCompat.consumePropertyBoolean(json, "explode");
        Boolean allowReserved = JsonCompat.consumePropertyBoolean(json, "allowReserved");
        Object example = JsonCompat.consumeProperty(json, "example");
        Object examples = JsonCompat.consumeProperty(json, "examples");
        Object content = JsonCompat.consumeProperty(json, "content");
        param.deprecated = deprecated;
        param.style = style;
        param.explode = explode;
        param.allowReserved = allowReserved;
        param.example = example;
        if (examples != null) {
            JsonCompat.keys(examples).forEach(name -> {
                Object exx = JsonCompat.consumeProperty(examples, name);
                Oas30Example exampleModel = param.createExample((String)name);
                this.readExample(exx, exampleModel);
                param.addExample(exampleModel);
            });
        }
        if (content != null) {
            JsonCompat.keys(content).forEach(name -> {
                Object mediaType = JsonCompat.consumeProperty(content, name);
                Oas30MediaType mediaTypeModel = param.createMediaType((String)name);
                this.readMediaType(mediaType, mediaTypeModel);
                param.addMediaType((String)name, mediaTypeModel);
            });
        }
        super.readParameter(json, node);
    }

    @Override
    public void readOperation(Object json, Operation node) {
        Oas30Operation operation = (Oas30Operation)node;
        Object requestBody = JsonCompat.consumeProperty(json, "requestBody");
        Object callbacks = JsonCompat.consumeProperty(json, "callbacks");
        List<Object> servers = JsonCompat.consumePropertyArray(json, "servers");
        if (requestBody != null) {
            operation.requestBody = operation.createRequestBody();
            this.readRequestBody(requestBody, operation.requestBody);
        }
        if (callbacks != null) {
            JsonCompat.keys(callbacks).forEach(name -> {
                Object callback = JsonCompat.consumeProperty(callbacks, name);
                Oas30Callback callbackModel = operation.createCallback((String)name);
                this.readCallback(callback, callbackModel);
                operation.addCallback((String)name, callbackModel);
            });
        }
        if (servers != null) {
            servers.forEach(server -> {
                Oas30Server serverModel = (Oas30Server)operation.createServer();
                this.readServer(server, serverModel);
                operation.addServer(serverModel);
            });
        }
        super.readOperation(json, node);
    }

    public void readCallback(Object json, Oas30Callback node) {
        JsonCompat.keys(json).forEach(name -> {
            if (NodeCompat.equals(name, "$ref")) {
                node.$ref = JsonCompat.consumePropertyString(json, name);
            } else {
                Object pathItem = JsonCompat.consumeProperty(json, name);
                Oas30CallbackPathItem pathItemModel = node.createPathItem((String)name);
                this.readPathItem(pathItem, pathItemModel);
                node.addPathItem((String)name, pathItemModel);
            }
        });
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readRequestBody(Object json, Oas30RequestBody node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object content = JsonCompat.consumeProperty(json, "content");
        Boolean required = JsonCompat.consumePropertyBoolean(json, "required");
        node.$ref = $ref;
        node.description = description;
        node.required = required;
        if (content != null) {
            JsonCompat.keys(content).forEach(name -> {
                Object mediaType = JsonCompat.consumeProperty(content, name);
                Oas30MediaType mediaTypeModel = node.createMediaType((String)name);
                this.readMediaType(mediaType, mediaTypeModel);
                node.addMediaType((String)name, mediaTypeModel);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readMediaType(Object json, Oas30MediaType node) {
        Object schema = JsonCompat.consumeProperty(json, "schema");
        Object example = JsonCompat.consumePropertyObject(json, "example");
        Object examples = JsonCompat.consumeProperty(json, "examples");
        Object encodings = JsonCompat.consumeProperty(json, "encoding");
        node.example = example;
        if (schema != null) {
            node.schema = node.createSchema();
            this.readSchema(schema, node.schema);
        }
        if (examples != null) {
            JsonCompat.keys(examples).forEach(name -> {
                Object exx = JsonCompat.consumeProperty(examples, name);
                Oas30Example exampleModel = (Oas30Example)node.createExample((String)name);
                this.readExample(exx, exampleModel);
                node.addExample(exampleModel);
            });
        }
        if (encodings != null) {
            JsonCompat.keys(encodings).forEach(name -> {
                Object encoding = JsonCompat.consumeProperty(encodings, name);
                Oas30Encoding encodingModel = node.createEncoding((String)name);
                this.readEncoding(encoding, encodingModel);
                node.addEncoding((String)name, encodingModel);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readExample(Object json, Oas30Example node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String summary = JsonCompat.consumePropertyString(json, "summary");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object value = JsonCompat.consumePropertyObject(json, "value");
        String externalValue = JsonCompat.consumePropertyString(json, "externalValue");
        node.$ref = $ref;
        node.summary = summary;
        node.description = description;
        node.value = value;
        node.externalValue = externalValue;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readEncoding(Object json, Oas30Encoding node) {
        String contentType = JsonCompat.consumePropertyString(json, "contentType");
        Object headers = JsonCompat.consumeProperty(json, "headers");
        String style = JsonCompat.consumePropertyString(json, "style");
        Boolean explode = JsonCompat.consumePropertyBoolean(json, "explode");
        Boolean allowReserved = JsonCompat.consumePropertyBoolean(json, "allowReserved");
        node.contentType = contentType;
        node.style = style;
        node.explode = explode;
        node.allowReserved = allowReserved;
        if (headers != null) {
            JsonCompat.keys(headers).forEach(name -> {
                Object header = JsonCompat.consumeProperty(headers, name);
                Oas30Header headerModel = node.createHeader((String)name);
                this.readHeader(header, headerModel);
                node.addHeader((String)name, headerModel);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readResponse(Object json, OasResponse node) {
        Oas30Response response = (Oas30Response)node;
        Object headers = JsonCompat.consumeProperty(json, "headers");
        Object content = JsonCompat.consumeProperty(json, "content");
        Object links = JsonCompat.consumeProperty(json, "links");
        if (headers != null) {
            JsonCompat.keys(headers).forEach(name -> {
                Object header = JsonCompat.consumeProperty(headers, name);
                Oas30Header headerModel = response.createHeader((String)name);
                this.readHeader(header, headerModel);
                response.addHeader((String)name, headerModel);
            });
        }
        if (content != null) {
            JsonCompat.keys(content).forEach(name -> {
                Object mediaType = JsonCompat.consumeProperty(content, name);
                Oas30MediaType mediaTypeModel = response.createMediaType((String)name);
                this.readMediaType(mediaType, mediaTypeModel);
                response.addMediaType((String)name, mediaTypeModel);
            });
        }
        if (links != null) {
            JsonCompat.keys(links).forEach(name -> {
                Object link = JsonCompat.consumeProperty(links, name);
                Oas30Link linkModel = response.createLink((String)name);
                this.readLink(link, linkModel);
                response.addLink((String)name, linkModel);
            });
        }
        super.readResponse(json, node);
    }

    public void readLink(Object json, Oas30Link node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String operationRef = JsonCompat.consumePropertyString(json, "operationRef");
        String operationId = JsonCompat.consumePropertyString(json, "operationId");
        Object parameters = JsonCompat.consumeProperty(json, "parameters");
        String requestBody = JsonCompat.consumePropertyString(json, "requestBody");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object server = JsonCompat.consumeProperty(json, "server");
        node.$ref = $ref;
        node.operationRef = operationRef;
        node.operationId = operationId;
        node.description = description;
        if (parameters != null) {
            JsonCompat.keys(parameters).forEach(name -> {
                String expression = JsonCompat.consumePropertyString(parameters, name);
                node.addLinkParameter((String)name, expression);
            });
        }
        if (requestBody != null) {
            node.requestBody = node.createLinkRequestBodyExpression(requestBody);
        }
        if (server != null) {
            node.server = node.createServer();
            this.readServer(server, node.server);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readSchema(Object json, Schema node) {
        Oas30Schema schema = (Oas30Schema)node;
        List<Object> oneOf = JsonCompat.consumePropertyArray(json, "oneOf");
        List<Object> anyOf = JsonCompat.consumePropertyArray(json, "anyOf");
        Object not = JsonCompat.consumeProperty(json, "not");
        Object discriminator = JsonCompat.consumeProperty(json, "discriminator");
        Boolean nullable = JsonCompat.consumePropertyBoolean(json, "nullable");
        Boolean writeOnly = JsonCompat.consumePropertyBoolean(json, "writeOnly");
        Boolean deprecated = JsonCompat.consumePropertyBoolean(json, "deprecated");
        schema.nullable = nullable;
        schema.writeOnly = writeOnly;
        schema.deprecated = deprecated;
        if (oneOf != null) {
            oneOf.forEach(oneOfSchema -> {
                Oas30Schema.Oas30OneOfSchema oneOfSchemaModel = schema.createOneOfSchema();
                this.readSchema(oneOfSchema, oneOfSchemaModel);
                schema.addOneOfSchema(oneOfSchemaModel);
            });
        }
        if (anyOf != null) {
            anyOf.forEach(anyOfSchema -> {
                Oas30Schema.Oas30AnyOfSchema anyOfSchemaModel = schema.createAnyOfSchema();
                this.readSchema(anyOfSchema, anyOfSchemaModel);
                schema.addAnyOfSchema(anyOfSchemaModel);
            });
        }
        if (not != null) {
            schema.not = schema.createNotSchema();
            this.readSchema(not, schema.not);
        }
        if (discriminator != null) {
            schema.discriminator = schema.createDiscriminator();
            this.readDiscriminator(discriminator, schema.discriminator);
        }
        super.readSchema(json, node);
    }

    public void readDiscriminator(Object json, Oas30Discriminator node) {
        String propertyName = JsonCompat.consumePropertyString(json, "propertyName");
        Object mapping = JsonCompat.consumeProperty(json, "mapping");
        node.propertyName = propertyName;
        if (mapping != null) {
            JsonCompat.keys(mapping).forEach(key -> {
                String value = JsonCompat.consumePropertyString(mapping, key);
                node.addMapping((String)key, value);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }
}

