/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.winrm;

import io.cloudsoft.winrm4j.client.ShellCommand;
import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.WinRmClientBuilder;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.retry.RetryPolicy;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)WinRmTool.class.getName());
    public static final int DEFAULT_WINRM_PORT = 5985;
    public static final int DEFAULT_WINRM_HTTPS_PORT = 5986;
    private final String address;
    private final String domain;
    private final String username;
    private final String password;
    private final String authenticationScheme;
    private Long operationTimeout;
    private Predicate<String> retryReceiveAfterOperationTimeout;
    private Integer retriesForConnectionFailures;
    private RetryPolicy failureRetryPolicy;
    private Long connectionTimeout;
    private Long receiveTimeout;
    private final boolean disableCertificateChecks;
    private final String workingDirectory;
    private final Map<String, String> environment;
    private final HostnameVerifier hostnameVerifier;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLContext sslContext;
    private final WinRmClientContext context;
    private final boolean requestNewKerberosTicket;

    private WinRmTool(String address, String domain, String username, String password, String authenticationScheme, boolean disableCertificateChecks, String workingDirectory, Map<String, String> environment, HostnameVerifier hostnameVerifier, SSLSocketFactory sslSocketFactory, SSLContext sslContext, WinRmClientContext context, boolean requestNewKerberosTicket) {
        this.disableCertificateChecks = disableCertificateChecks;
        this.address = address;
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.authenticationScheme = authenticationScheme;
        this.workingDirectory = workingDirectory;
        this.environment = environment;
        this.hostnameVerifier = hostnameVerifier;
        this.sslSocketFactory = sslSocketFactory;
        this.sslContext = sslContext;
        this.context = context;
        this.requestNewKerberosTicket = requestNewKerberosTicket;
    }

    public WinRmToolResponse executeCommand(List<String> commands) {
        return this.executeCommand(this.joinCommands(commands));
    }

    public WinRmToolResponse executeCommand(List<String> commands, Writer out, Writer err) {
        return this.executeCommand(this.joinCommands(commands), out, err);
    }

    public void setOperationTimeout(Long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRetryReceiveAfterOperationTimeout(Predicate<String> retryReceiveAfterOperationTimeout) {
        this.retryReceiveAfterOperationTimeout = retryReceiveAfterOperationTimeout;
    }

    public void alwaysRetryReceiveAfterOperationTimeout() {
        this.setRetryReceiveAfterOperationTimeout(WinRmClientBuilder.alwaysRetryReceiveAfterOperationTimeout());
    }

    public void neverRetryReceiveAfterOperationTimeout() {
        this.setRetryReceiveAfterOperationTimeout(WinRmClientBuilder.neverRetryReceiveAfterOperationTimeout());
    }

    public void setRetriesForConnectionFailures(Integer retriesForConnectionFailures) {
        this.setFailureRetryPolicy(WinRmClientBuilder.simpleCounterRetryPolicy((int)retriesForConnectionFailures));
    }

    public void setFailureRetryPolicy(RetryPolicy failureRetryPolicy) {
        this.failureRetryPolicy = failureRetryPolicy;
    }

    public WinRmToolResponse executeCommand(String command) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        return this.executeCommand(command, (Writer)out, (Writer)err);
    }

    public WinRmToolResponse executeCommand(String command, Writer out, Writer err) {
        WinRmToolResponse winRmToolResponse;
        WinRmClient.checkNotNull((Object)out, (String)"Out Writer");
        WinRmClient.checkNotNull((Object)err, (String)"Err Writer");
        WinRmClientBuilder builder = WinRmClient.builder((String)this.address);
        builder.authenticationScheme(this.authenticationScheme);
        if (this.operationTimeout != null) {
            builder.operationTimeout(this.operationTimeout.longValue());
        }
        if (this.retryReceiveAfterOperationTimeout != null) {
            builder.retryReceiveAfterOperationTimeout(this.retryReceiveAfterOperationTimeout);
        }
        if (this.connectionTimeout != null) {
            builder.connectionTimeout(this.connectionTimeout.longValue());
        }
        if (this.receiveTimeout != null) {
            builder.receiveTimeout(this.receiveTimeout);
        }
        if (this.username != null && this.password != null) {
            builder.credentials(this.domain, this.username, this.password);
        }
        if (this.disableCertificateChecks) {
            LOG.trace("Disabled check for https connections " + this);
            builder.disableCertificateChecks(this.disableCertificateChecks);
        }
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.sslSocketFactory != null) {
            builder.sslSocketFactory(this.sslSocketFactory);
        }
        if (this.sslContext != null) {
            builder.sslContext(this.sslContext);
        }
        if (this.workingDirectory != null) {
            builder.workingDirectory(this.workingDirectory);
        }
        if (this.environment != null) {
            builder.environment(this.environment);
        }
        if (this.failureRetryPolicy != null) {
            builder.failureRetryPolicy(this.failureRetryPolicy);
        }
        if (this.context != null) {
            builder.context(this.context);
        }
        if (this.requestNewKerberosTicket) {
            builder.requestNewKerberosTicket(this.requestNewKerberosTicket);
        }
        try (WinRmClient client = builder.build();
             ShellCommand shell = client.createShell();){
            int code = shell.execute(command, out, err);
            winRmToolResponse = new WinRmToolResponse(out.toString(), err.toString(), code);
            winRmToolResponse.setNumberOfReceiveCalls(shell.getNumberOfReceiveCalls());
        }
        return winRmToolResponse;
    }

    public WinRmToolResponse executePs(String psCommand) {
        return this.executePs(psCommand, (Writer)new StringWriter(), (Writer)new StringWriter());
    }

    public WinRmToolResponse executePs(String psCommand, Writer out, Writer err) {
        return this.executeCommand(this.compilePs(psCommand), out, err);
    }

    public WinRmToolResponse executePs(List<String> commands) {
        return this.executePs(commands, (Writer)new StringWriter(), (Writer)new StringWriter());
    }

    public WinRmToolResponse executePs(List<String> commands, Writer out, Writer err) {
        return this.executeCommand(this.compilePs(this.joinPs(commands)), out, err);
    }

    private String compilePs(String psScript) {
        byte[] cmd = psScript.getBytes(Charset.forName("UTF-16LE"));
        String arg = DatatypeConverter.printBase64Binary((byte[])cmd);
        return "powershell -encodedcommand " + arg;
    }

    @Deprecated
    public WinRmToolResponse executeScript(List<String> commands) {
        return this.executeCommand(commands);
    }

    @Deprecated
    public WinRmToolResponse executeScript(String commands) {
        return this.executeCommand(commands);
    }

    private String joinCommands(List<String> commands) {
        return this.join(commands, " & ", false);
    }

    private String joinPs(List<String> commands) {
        return this.join(commands, "\r\n", true);
    }

    private String join(List<String> commands, String delim, boolean endWithDelim) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String command : commands) {
            if (first) {
                first = false;
            } else {
                builder.append(delim);
            }
            builder.append(command);
        }
        if (endWithDelim) {
            builder.append(delim);
        }
        return builder.toString();
    }

    public static class Builder {
        private String authenticationScheme = "NTLM";
        private Boolean useHttps;
        private Integer port = null;
        private boolean disableCertificateChecks = false;
        private String address;
        private String domain;
        private String username;
        private String password;
        private String workingDirectory;
        private Map<String, String> environment;
        private HostnameVerifier hostnameVerifier;
        private SSLSocketFactory sslSocketFactory;
        private SSLContext sslContext;
        private WinRmClientContext context;
        private boolean requestNewKerberosTicket;
        private static final Pattern matchPort = Pattern.compile(".*:(\\d+)$");

        public static Builder builder(String address, String username, String password) {
            return Builder.builder(address, null, username, password);
        }

        public static Builder builder(String address, String domain, String username, String password) {
            return new Builder(address, domain, username, password);
        }

        private Builder(String address, String domain, String username, String password) {
            this.address = address;
            this.domain = domain;
            this.username = username;
            this.password = password;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = (String)WinRmClient.checkNotNull((Object)workingDirectory, (String)"workingDirectory");
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = (Map)WinRmClient.checkNotNull(environment, (String)"environment");
            return this;
        }

        @Deprecated
        public Builder setAuthenticationScheme(String authenticationScheme) {
            return this.authenticationScheme(authenticationScheme);
        }

        public Builder authenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public Builder disableCertificateChecks(boolean disableCertificateChecks) {
            this.disableCertificateChecks = disableCertificateChecks;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder context(WinRmClientContext context) {
            this.context = context;
            return this;
        }

        public Builder requestNewKerberosTicket(boolean requestNewKerberosTicket) {
            this.requestNewKerberosTicket = requestNewKerberosTicket;
            return this;
        }

        public WinRmTool build() {
            return new WinRmTool(Builder.getEndpointUrl(this.address, this.useHttps, this.port), this.domain, this.username, this.password, this.authenticationScheme, this.disableCertificateChecks, this.workingDirectory, this.environment, this.hostnameVerifier, this.sslSocketFactory, this.sslContext, this.context, this.requestNewKerberosTicket);
        }

        private static String getEndpointUrl(String address, Boolean useHttps, Integer port) {
            if (address.startsWith("http:") || address.startsWith("https:")) {
                if (useHttps != null) {
                    if (useHttps.booleanValue() && address.startsWith("http:")) {
                        throw new IllegalArgumentException("Invalid setting useHttps and address starting http://");
                    }
                    if (!useHttps.booleanValue() && address.startsWith("https:")) {
                        throw new IllegalArgumentException("Invalid setting useHttp and address starting https://");
                    }
                }
                return address;
            }
            Matcher matcher = matchPort.matcher(address);
            if (matcher.matches()) {
                if (useHttps == null) {
                    useHttps = matcher.group(1).equals("5986");
                }
                return (useHttps != false ? "https" : "http") + "://" + address + "/wsman";
            }
            if (useHttps != null) {
                port = port != null ? port : (useHttps != false ? 5986 : 5985);
            }
            if (useHttps != null && useHttps.booleanValue()) {
                return "https://" + address + ":" + port + "/wsman";
            }
            return "http://" + address + ":" + port + "/wsman";
        }
    }
}

