/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.legacy.Filters;
import io.debezium.connector.mysql.legacy.MySqlJdbcContext;
import io.debezium.connector.mysql.legacy.MySqlSchema;
import io.debezium.connector.mysql.legacy.RecordMakers;
import io.debezium.connector.mysql.legacy.SourceInfo;
import io.debezium.function.Predicates;
import io.debezium.relational.TableId;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.schema.TopicSelector;
import io.debezium.util.LoggingContext;
import io.debezium.util.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySqlTaskContext
extends CdcSourceTaskContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlTaskContext.class);
    private final MySqlJdbcContext connectionContext;
    private final Configuration config;
    private final MySqlConnectorConfig connectorConfig;
    private final SourceInfo source;
    private final MySqlSchema dbSchema;
    private final TopicSelector<TableId> topicSelector;
    private final RecordMakers recordProcessor;
    private final Predicate<String> gtidSourceFilter;
    private final Predicate<String> ddlFilter;
    private final boolean tableIdCaseInsensitive;

    public MySqlTaskContext(Configuration config, Filters filters) {
        this(config, filters, null, null);
    }

    public MySqlTaskContext(Configuration config, Filters filters, Map<String, ?> restartOffset) {
        this(config, filters, null, restartOffset);
    }

    public MySqlTaskContext(Configuration config, Filters filters, Boolean tableIdCaseInsensitive, Map<String, ?> restartOffset) {
        super(Module.contextName(), config.getString(MySqlConnectorConfig.SERVER_NAME), Collections::emptyList);
        this.config = config;
        this.connectorConfig = new MySqlConnectorConfig(config);
        this.connectionContext = new MySqlJdbcContext(this.connectorConfig);
        this.topicSelector = MySqlTopicSelector.defaultSelector(this.connectorConfig.getLogicalName(), this.connectorConfig.getHeartbeatTopicsPrefix());
        this.source = new SourceInfo(this.connectorConfig);
        String gtidSetIncludes = config.getString(MySqlConnectorConfig.GTID_SOURCE_INCLUDES);
        String gtidSetExcludes = config.getString(MySqlConnectorConfig.GTID_SOURCE_EXCLUDES);
        Predicate predicate = gtidSetIncludes != null ? Predicates.includesUuids((String)gtidSetIncludes) : (this.gtidSourceFilter = gtidSetExcludes != null ? Predicates.excludesUuids((String)gtidSetExcludes) : null);
        this.tableIdCaseInsensitive = tableIdCaseInsensitive == null ? !"0".equals(this.connectionContext.readMySqlSystemVariables().get("lower_case_table_names")) : tableIdCaseInsensitive;
        this.dbSchema = new MySqlSchema(this.connectorConfig, this.gtidSourceFilter, this.tableIdCaseInsensitive, this.topicSelector, filters);
        this.recordProcessor = new RecordMakers(this.dbSchema, this.source, this.topicSelector, this.connectorConfig.isEmitTombstoneOnDelete(), restartOffset);
        String ddlFilter = config.getString(DatabaseHistory.DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.includes((String)ddlFilter) : x -> false;
    }

    public Configuration config() {
        return this.config;
    }

    public MySqlConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public MySqlJdbcContext getConnectionContext() {
        return this.connectionContext;
    }

    public String connectorName() {
        return this.config.getString("name");
    }

    public TopicSelector<TableId> topicSelector() {
        return this.topicSelector;
    }

    public SourceInfo source() {
        return this.source;
    }

    public MySqlSchema dbSchema() {
        return this.dbSchema;
    }

    public RecordMakers makeRecord() {
        return this.recordProcessor;
    }

    public Predicate<String> gtidSourceFilter() {
        return this.gtidSourceFilter;
    }

    public void initializeHistory() {
        Map<String, String> variables = this.connectionContext.readMySqlCharsetSystemVariables();
        String ddlStatement = this.connectionContext.setStatementFor(variables);
        this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
    }

    public void loadHistory(SourceInfo startingPoint) {
        Map<String, String> variables = this.connectionContext.readMySqlCharsetSystemVariables();
        this.dbSchema.setSystemVariables(variables);
        this.dbSchema.loadHistory(startingPoint);
        String systemCharsetName = variables.get("character_set_server");
        String systemCharsetNameFromHistory = this.dbSchema.systemVariables().getVariable("character_set_server");
        if (!Strings.equalsIgnoreCase((String)systemCharsetName, (String)systemCharsetNameFromHistory)) {
            String ddlStatement = this.connectionContext.setStatementFor(variables);
            this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
        }
        this.recordProcessor.regenerate();
    }

    public boolean historyExists() {
        Map<String, String> variables = this.connectionContext.readMySqlCharsetSystemVariables();
        this.dbSchema.setSystemVariables(variables);
        return this.dbSchema.historyExists();
    }

    public void initializeHistoryStorage() {
        this.dbSchema.intializeHistoryStorage();
    }

    public long serverId() {
        return this.config.getLong(MySqlConnectorConfig.SERVER_ID);
    }

    public long rowCountForLargeTable() {
        return this.config.getLong(MySqlConnectorConfig.ROW_COUNT_FOR_STREAMING_RESULT_SETS);
    }

    public int bufferSizeForBinlogReader() {
        return this.config.getInteger(MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER);
    }

    public boolean includeSchemaChangeRecords() {
        return this.config.getBoolean(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES);
    }

    public boolean includeSqlQuery() {
        return this.config.getBoolean(MySqlConnectorConfig.INCLUDE_SQL_QUERY);
    }

    public boolean isSnapshotAllowedWhenNeeded() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED;
    }

    public boolean isSnapshotNeverAllowed() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.NEVER;
    }

    public boolean isInitialSnapshotOnly() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.INITIAL_ONLY;
    }

    public boolean isSchemaOnlySnapshot() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY;
    }

    public boolean isSchemaOnlyRecoverySnapshot() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY_RECOVERY;
    }

    protected MySqlConnectorConfig.SnapshotMode snapshotMode() {
        String value = this.config.getString(MySqlConnectorConfig.SNAPSHOT_MODE);
        return MySqlConnectorConfig.SnapshotMode.parse(value, MySqlConnectorConfig.SNAPSHOT_MODE.defaultValueAsString());
    }

    public void start() {
        this.connectionContext.start();
        this.dbSchema().start();
    }

    public void shutdown() {
        try {
            LOGGER.debug("Stopping database history");
            this.dbSchema.shutdown();
        }
        catch (Throwable e) {
            LOGGER.error("Unexpected error shutting down the database history", e);
        }
        finally {
            this.connectionContext.shutdown();
        }
    }

    public void temporaryLoggingContext(String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector((String)"MySQL", (String)this.connectorConfig.getLogicalName(), (String)contextName, (Runnable)operation);
    }

    public GtidSet filterGtidSet(GtidSet availableServerGtidSet, GtidSet purgedServerGtid) {
        GtidSet mergedGtidSet;
        String gtidStr = this.source.gtidSet();
        if (gtidStr == null) {
            return null;
        }
        LOGGER.info("Attempting to generate a filtered GTID set");
        LOGGER.info("GTID set from previous recorded offset: {}", (Object)gtidStr);
        GtidSet filteredGtidSet = new GtidSet(gtidStr);
        Predicate<String> gtidSourceFilter = this.gtidSourceFilter();
        if (gtidSourceFilter != null) {
            filteredGtidSet = filteredGtidSet.retainAll(gtidSourceFilter);
            LOGGER.info("GTID set after applying GTID source includes/excludes to previous recorded offset: {}", (Object)filteredGtidSet);
        }
        LOGGER.info("GTID set available on server: {}", (Object)availableServerGtidSet);
        if (this.connectorConfig.gtidNewChannelPosition() == MySqlConnectorConfig.GtidNewChannelPosition.EARLIEST) {
            GtidSet knownGtidSet = filteredGtidSet;
            LOGGER.info("Using first available positions for new GTID channels");
            GtidSet relevantAvailableServerGtidSet = gtidSourceFilter != null ? availableServerGtidSet.retainAll(gtidSourceFilter) : availableServerGtidSet;
            LOGGER.info("Relevant GTID set available on server: {}", (Object)relevantAvailableServerGtidSet);
            mergedGtidSet = relevantAvailableServerGtidSet.retainAll(uuid -> knownGtidSet.forServerWithId((String)uuid) != null).with(purgedServerGtid).with(filteredGtidSet);
        } else {
            mergedGtidSet = availableServerGtidSet.with(filteredGtidSet);
        }
        LOGGER.info("Final merged GTID set to use when connecting to MySQL: {}", (Object)mergedGtidSet);
        return mergedGtidSet;
    }

    public Predicate<String> ddlFilter() {
        return this.ddlFilter;
    }

    public boolean isTableIdCaseInsensitive() {
        return this.tableIdCaseInsensitive;
    }
}

