/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.apt.AptAnnotationFactory;
import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class ToAnnotationValueVisitor
implements AnnotationValueVisitor<Object, Object> {
    private final Elements elements;
    private boolean mapVoidToNull;
    private boolean mapFalseToNull;
    private boolean mapEmptyStringToNull;
    private boolean mapBlankArrayToNull;
    private boolean mapToSourceDeclaration;

    ToAnnotationValueVisitor(Elements elements) {
        this.elements = elements;
    }

    ToAnnotationValueVisitor mapVoidToNull(boolean val) {
        this.mapVoidToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapBooleanToNull(boolean val) {
        this.mapFalseToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapEmptyStringToNull(boolean val) {
        this.mapEmptyStringToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapBlankArrayToNull(boolean val) {
        this.mapBlankArrayToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapToSourceDeclaration(boolean val) {
        this.mapToSourceDeclaration = val;
        return this;
    }

    @Override
    public Object visit(AnnotationValue av, Object o) {
        return av.accept(this, o);
    }

    @Override
    public Object visitBoolean(boolean b, Object o) {
        if (!b && this.mapFalseToNull) {
            return null;
        }
        return b;
    }

    @Override
    public Object visitByte(byte b, Object o) {
        return b;
    }

    @Override
    public Object visitChar(char c, Object o) {
        return Character.valueOf(c);
    }

    @Override
    public Object visitDouble(double d, Object o) {
        return d;
    }

    @Override
    public Object visitFloat(float f, Object o) {
        return Float.valueOf(f);
    }

    @Override
    public Object visitInt(int i, Object o) {
        return i;
    }

    @Override
    public Object visitLong(long i, Object o) {
        return i;
    }

    @Override
    public Object visitShort(short s, Object o) {
        return s;
    }

    @Override
    public Object visitString(String s, Object o) {
        if (this.mapEmptyStringToNull && s != null && s.isBlank()) {
            return null;
        }
        if (this.mapToSourceDeclaration) {
            return "\"" + s + "\"";
        }
        return s;
    }

    @Override
    public Object visitType(TypeMirror t, Object o) {
        Optional<TypeName> maybeType = AptTypeFactory.createTypeName(t);
        if (maybeType.isEmpty()) {
            return null;
        }
        TypeName type = maybeType.get();
        if (this.mapVoidToNull && (type.equals((Object)TypeNames.BOXED_VOID) || type.equals((Object)TypeNames.PRIMITIVE_VOID))) {
            return null;
        }
        return type;
    }

    @Override
    public Object visitEnumConstant(VariableElement c, Object o) {
        Optional<TypeName> maybeType = AptTypeFactory.createTypeName(c.getEnclosingElement());
        if (maybeType.isEmpty()) {
            return String.valueOf(c.getSimpleName());
        }
        return EnumValue.create((TypeName)maybeType.get(), (String)String.valueOf(c.getSimpleName()));
    }

    @Override
    public Object visitAnnotation(AnnotationMirror a, Object o) {
        return AptAnnotationFactory.createAnnotation(a, this.elements);
    }

    @Override
    public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
        ArrayList<Object> values = new ArrayList<Object>(vals.size());
        for (AnnotationValue annotationValue : vals) {
            Object elementValue = annotationValue.accept(this, null);
            if (elementValue == null) continue;
            values.add(elementValue);
        }
        if (this.mapBlankArrayToNull && values.isEmpty()) {
            return null;
        }
        if (this.mapToSourceDeclaration) {
            return vals.stream().map(v -> v.accept(this, null)).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(", ", "{", "}"));
        }
        return values;
    }

    @Override
    public String visitUnknown(AnnotationValue av, Object o) {
        return null;
    }
}

