/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenEventBlueprint;
import io.helidon.common.Errors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface CodegenEvent
extends CodegenEventBlueprint {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CodegenEvent instance) {
        return (Builder)CodegenEvent.builder().from(instance);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        private Builder() {
        }

        public CodegenEvent build() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CodegenEventImpl(this);
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER>>
    implements io.helidon.common.Builder<BUILDER, CodegenEvent> {
        private final List<Object> objects = new ArrayList<Object>();
        private System.Logger.Level level = System.Logger.Level.INFO;
        private String message;
        private Throwable throwable;

        protected BuilderBase() {
        }

        public BUILDER from(CodegenEvent prototype) {
            this.level(prototype.level());
            this.message(prototype.message());
            this.throwable(prototype.throwable());
            this.addObjects(prototype.objects());
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER from(BuilderBase<?> builder) {
            this.level(builder.level());
            builder.message().ifPresent(this::message);
            builder.throwable().ifPresent(this::throwable);
            this.addObjects(builder.objects());
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER level(System.Logger.Level level) {
            Objects.requireNonNull(level);
            this.level = level;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER message(String message) {
            Objects.requireNonNull(message);
            this.message = message;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER clearThrowable() {
            this.throwable = null;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER throwable(Throwable throwable) {
            Objects.requireNonNull(throwable);
            this.throwable = throwable;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER objects(List<?> objects) {
            Objects.requireNonNull(objects);
            this.objects.clear();
            this.objects.addAll(objects);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addObjects(List<?> objects) {
            Objects.requireNonNull(objects);
            this.objects.addAll(objects);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addObject(Object object) {
            Objects.requireNonNull(object);
            this.objects.add(object);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public System.Logger.Level level() {
            return this.level;
        }

        public Optional<String> message() {
            return Optional.ofNullable(this.message);
        }

        public Optional<Throwable> throwable() {
            return Optional.ofNullable(this.throwable);
        }

        public List<Object> objects() {
            return this.objects;
        }

        public String toString() {
            return "CodegenEventBuilder{level=" + String.valueOf((Object)this.level) + ",message=" + this.message + ",throwable=" + String.valueOf(this.throwable) + ",objects=" + String.valueOf(this.objects) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.message == null) {
                collector.fatal(this.getClass(), "Property \"message\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER throwable(Optional<? extends Throwable> throwable) {
            Objects.requireNonNull(throwable);
            this.throwable = throwable.map(Throwable.class::cast).orElse(this.throwable);
            return (BUILDER)((BuilderBase)this.identity());
        }

        protected static class CodegenEventImpl
        implements CodegenEvent {
            private final System.Logger.Level level;
            private final List<Object> objects;
            private final Optional<Throwable> throwable;
            private final String message;

            protected CodegenEventImpl(BuilderBase<?> builder) {
                this.level = builder.level();
                this.message = builder.message().get();
                this.throwable = builder.throwable();
                this.objects = List.copyOf(builder.objects());
            }

            @Override
            public System.Logger.Level level() {
                return this.level;
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public Optional<Throwable> throwable() {
                return this.throwable;
            }

            @Override
            public List<Object> objects() {
                return this.objects;
            }

            public String toString() {
                return "CodegenEvent{level=" + String.valueOf((Object)this.level) + ",message=" + this.message + ",throwable=" + String.valueOf(this.throwable) + ",objects=" + String.valueOf(this.objects) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CodegenEvent)) {
                    return false;
                }
                CodegenEvent other = (CodegenEvent)o;
                return Objects.equals((Object)this.level, (Object)other.level()) && Objects.equals(this.message, other.message()) && Objects.equals(this.throwable, other.throwable()) && Objects.equals(this.objects, other.objects());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.level, this.message, this.throwable, this.objects});
            }
        }
    }
}

