/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.checks.DeadlockHealthCheck;
import io.helidon.health.checks.DiskSpaceHealthCheck;
import io.helidon.health.checks.HeapMemoryHealthCheck;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;

public final class HealthChecks {
    static final String CONFIG_KEY_HEALTH_PREFIX = "helidon.health";

    private HealthChecks() {
    }

    public static HealthCheck deadlockCheck() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    public static HealthCheck diskSpaceCheck() {
        return DiskSpaceHealthCheck.create();
    }

    public static HealthCheck diskSpaceCheck(Config config) {
        return DiskSpaceHealthCheck.builder().config(config).build();
    }

    public static HeapMemoryHealthCheck heapMemoryCheck() {
        return HeapMemoryHealthCheck.create();
    }

    public static HeapMemoryHealthCheck heapMemoryCheck(Config config) {
        return HeapMemoryHealthCheck.builder().config(config).build();
    }

    public static HealthCheck[] healthChecks() {
        if (NativeImageHelper.isNativeImage()) {
            return new HealthCheck[]{HealthChecks.heapMemoryCheck()};
        }
        return new HealthCheck[]{HealthChecks.deadlockCheck(), HealthChecks.diskSpaceCheck(), HealthChecks.heapMemoryCheck()};
    }

    public static HealthCheck[] healthChecks(Config config) {
        ArrayList<HealthCheck> result = new ArrayList<HealthCheck>();
        if (!NativeImageHelper.isNativeImage()) {
            result.add(HealthChecks.deadlockCheck());
            result.add(HealthChecks.diskSpaceCheck(config.get("diskSpace")));
        }
        result.add(HealthChecks.heapMemoryCheck(config.get("heapMemory")));
        return result.toArray(new HealthCheck[0]);
    }
}

