/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.media.EntityReader;
import jakarta.json.bind.Jsonb;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class JsonbReader<T>
implements EntityReader<T> {
    private final Jsonb jsonb;

    JsonbReader(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public T read(GenericType<T> type, InputStream stream, Headers headers) {
        return this.read(type, stream, this.contentTypeCharset(headers));
    }

    public T read(GenericType<T> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
        return this.read(type, stream, this.contentTypeCharset(responseHeaders));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T read(GenericType<T> type, InputStream in, Charset charset) {
        try (InputStreamReader r = new InputStreamReader(in, charset);){
            Object object = this.jsonb.fromJson((Reader)r, type.type());
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Charset contentTypeCharset(Headers headers) {
        return headers.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }
}

