/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.helidon.common.LazyValue;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.common.types.TypeName;
import io.helidon.integrations.langchain4j.EmbeddingStoreContentRetrieverConfig;
import io.helidon.service.registry.Service;
import java.util.Optional;
import java.util.function.Supplier;

@Weight(value=90.0)
@Service.Singleton
public class EmbeddingStoreContentRetrieverFactory
implements Supplier<Optional<EmbeddingStoreContentRetriever>> {
    private static final TypeName STORE_TYPE = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(EmbeddingStore.class)).addTypeArgument(TypeName.create(TextSegment.class))).build();
    private final LazyValue<Optional<EmbeddingStoreContentRetriever>> contentRetriever;

    @Service.Inject
    EmbeddingStoreContentRetrieverFactory(Supplier<EmbeddingStore<TextSegment>> embeddingStore, Supplier<Optional<EmbeddingModel>> embeddingModel, Config config) {
        EmbeddingStoreContentRetrieverConfig.Builder configBuilder = (EmbeddingStoreContentRetrieverConfig.Builder)EmbeddingStoreContentRetrieverConfig.builder().config(config.get("langchain4j.rag.embedding-store-content-retriever"));
        this.contentRetriever = configBuilder.enabled() ? LazyValue.create(() -> {
            if (!configBuilder.enabled()) {
                return Optional.empty();
            }
            configBuilder.embeddingStore((EmbeddingStore<TextSegment>)((EmbeddingStore)embeddingStore.get()));
            ((Optional)embeddingModel.get()).ifPresent(configBuilder::embeddingModel);
            return Optional.of(EmbeddingStoreContentRetrieverFactory.create(configBuilder.build()));
        }) : LazyValue.create(Optional.empty());
    }

    public static EmbeddingStoreContentRetriever create(EmbeddingStoreContentRetrieverConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a retriever when the configuration is disabled.");
        }
        EmbeddingStoreContentRetriever.EmbeddingStoreContentRetrieverBuilder builder = EmbeddingStoreContentRetriever.builder();
        config.embeddingModel().ifPresent(arg_0 -> ((EmbeddingStoreContentRetriever.EmbeddingStoreContentRetrieverBuilder)builder).embeddingModel(arg_0));
        builder.embeddingStore(config.embeddingStore());
        config.displayName().ifPresent(arg_0 -> ((EmbeddingStoreContentRetriever.EmbeddingStoreContentRetrieverBuilder)builder).displayName(arg_0));
        config.maxResults().ifPresent(arg_0 -> ((EmbeddingStoreContentRetriever.EmbeddingStoreContentRetrieverBuilder)builder).maxResults(arg_0));
        config.minScore().ifPresent(arg_0 -> ((EmbeddingStoreContentRetriever.EmbeddingStoreContentRetrieverBuilder)builder).minScore(arg_0));
        return builder.build();
    }

    @Override
    public Optional<EmbeddingStoreContentRetriever> get() {
        return (Optional)this.contentRetriever.get();
    }
}

