/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.providers.micrometer.MDistributionSummary;
import io.helidon.metrics.providers.micrometer.Util;
import io.micrometer.core.instrument.DistributionSummary;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

class MDistributionStatisticsConfig
implements DistributionStatisticsConfig {
    private final double[] percentiles;
    private final double[] buckets;
    private final Optional<Double> minimumExpectedValue;
    private final Optional<Double> maximumExpectedValue;

    private MDistributionStatisticsConfig(Builder builder) {
        this.percentiles = builder.percentiles;
        this.buckets = builder.buckets;
        this.minimumExpectedValue = builder.minimumExpectedValue();
        this.maximumExpectedValue = builder.maximumExpectedValue();
    }

    static Builder builder(DistributionSummary.Builder micrometerSummaryBuilder) {
        return new Builder(micrometerSummaryBuilder);
    }

    static <T> T chooseOpt(T fromChild, Supplier<Optional<T>> fromParent) {
        return (T)Objects.requireNonNullElseGet(fromChild, () -> ((Optional)fromParent.get()).orElse(null));
    }

    static Builder builderFrom(MDistributionSummary.Builder sBuilder, DistributionStatisticsConfig.Builder other) {
        Builder configBuilder = MDistributionStatisticsConfig.builder((DistributionSummary.Builder)sBuilder.delegate());
        configBuilder.from(other);
        return configBuilder;
    }

    public Optional<Iterable<Double>> percentiles() {
        return Optional.ofNullable(Util.iterable(this.percentiles));
    }

    public Optional<Double> minimumExpectedValue() {
        return this.minimumExpectedValue;
    }

    public Optional<Double> maximumExpectedValue() {
        return this.maximumExpectedValue;
    }

    public Optional<Iterable<Double>> buckets() {
        return Optional.ofNullable(Util.iterable(this.buckets));
    }

    public <R> R unwrap(Class<? extends R> c) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not have a delegate to unwrap");
    }

    static class Builder
    implements DistributionStatisticsConfig.Builder {
        static final double[] DEFAULT_PERCENTILES = new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
        static final int DEFAULT_PRECISION = 3;
        private final DistributionSummary.Builder delegate;
        private Optional<Double> min = Optional.empty();
        private Optional<Double> max = Optional.empty();
        private double[] percentiles = DEFAULT_PERCENTILES;
        private double[] buckets;

        private Builder(DistributionSummary.Builder delegate) {
            this.delegate = delegate;
            delegate.percentilePrecision(Integer.valueOf(3));
            delegate.publishPercentiles(DEFAULT_PERCENTILES);
        }

        public MDistributionStatisticsConfig build() {
            return new MDistributionStatisticsConfig(this);
        }

        public Builder minimumExpectedValue(Double min) {
            this.min = Optional.of(min);
            this.delegate.minimumExpectedValue(min);
            return this;
        }

        public Builder maximumExpectedValue(Double max) {
            this.max = Optional.of(max);
            this.delegate.maximumExpectedValue(max);
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            this.percentiles = percentiles;
            this.delegate.publishPercentiles(percentiles);
            return this;
        }

        public Builder percentiles(Iterable<Double> percentiles) {
            this.percentiles = Util.doubleArray(percentiles);
            this.delegate.publishPercentiles(this.percentiles);
            return this;
        }

        public Builder buckets(double ... buckets) {
            this.buckets = buckets;
            this.delegate.serviceLevelObjectives(buckets);
            return this;
        }

        public Builder buckets(Iterable<Double> buckets) {
            this.buckets = Util.doubleArray(buckets);
            this.delegate.serviceLevelObjectives(this.buckets);
            return this;
        }

        public Optional<Double> minimumExpectedValue() {
            return this.min;
        }

        public Optional<Double> maximumExpectedValue() {
            return this.max;
        }

        public Iterable<Double> percentiles() {
            return Util.iterable(this.percentiles);
        }

        public Iterable<Double> buckets() {
            return Util.iterable(this.buckets);
        }

        public <R> R unwrap(Class<? extends R> c) {
            if (c.isInstance(this.delegate)) {
                return c.cast(this.delegate);
            }
            if (c.isInstance(this)) {
                return c.cast(this);
            }
            throw new IllegalArgumentException("Cannot unwrap to " + c.getName());
        }

        public Builder from(DistributionStatisticsConfig.Builder other) {
            other.minimumExpectedValue().ifPresent(this::minimumExpectedValue);
            other.maximumExpectedValue().ifPresent(this::maximumExpectedValue);
            this.buckets = Util.doubleArray(other.buckets());
            this.percentiles = Util.doubleArray(other.percentiles());
            return this;
        }
    }

    static class Unconnected
    implements DistributionStatisticsConfig {
        private Optional<Double> min = Optional.empty();
        private Optional<Double> max = Optional.empty();
        private double[] percentiles;
        private double[] buckets;

        static Builder builder() {
            return new Builder();
        }

        private Unconnected(DistributionStatisticsConfig.Builder builder) {
            this.min = builder.minimumExpectedValue();
            this.max = builder.maximumExpectedValue();
            this.percentiles = Util.doubleArray(builder.percentiles());
            this.buckets = Util.doubleArray(builder.buckets());
        }

        public Optional<Iterable<Double>> percentiles() {
            return Optional.ofNullable(Util.iterable(this.percentiles));
        }

        public Optional<Double> minimumExpectedValue() {
            return this.min;
        }

        public Optional<Double> maximumExpectedValue() {
            return this.max;
        }

        public Optional<Iterable<Double>> buckets() {
            return Optional.ofNullable(Util.iterable(this.buckets));
        }

        public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this);
        }

        static class Builder
        implements DistributionStatisticsConfig.Builder {
            private Optional<Double> min = Optional.empty();
            private Optional<Double> max = Optional.empty();
            private double[] percentiles = io.helidon.metrics.providers.micrometer.MDistributionStatisticsConfig$Builder.DEFAULT_PERCENTILES;
            private double[] buckets;

            Builder() {
            }

            public DistributionStatisticsConfig.Builder minimumExpectedValue(Double min) {
                this.min = Optional.of(min);
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public DistributionStatisticsConfig.Builder maximumExpectedValue(Double max) {
                this.max = Optional.of(max);
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public DistributionStatisticsConfig.Builder percentiles(double ... percentiles) {
                this.percentiles = percentiles;
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public DistributionStatisticsConfig.Builder percentiles(Iterable<Double> percentiles) {
                this.percentiles = Util.doubleArray(percentiles);
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public DistributionStatisticsConfig.Builder buckets(double ... buckets) {
                this.buckets = buckets;
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public DistributionStatisticsConfig.Builder buckets(Iterable<Double> buckets) {
                this.buckets = Util.doubleArray(buckets);
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            public Optional<Double> minimumExpectedValue() {
                return this.min;
            }

            public Optional<Double> maximumExpectedValue() {
                return this.max;
            }

            public Iterable<Double> percentiles() {
                return Util.iterable(this.percentiles);
            }

            public Iterable<Double> buckets() {
                return Util.iterable(this.buckets);
            }

            public DistributionStatisticsConfig build() {
                return new Unconnected(this);
            }

            public <R> R unwrap(Class<? extends R> c) {
                return c.cast(this);
            }
        }
    }
}

