/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricsInterceptorBase;
import java.lang.annotation.Annotation;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metric;

abstract class InterceptorTimedBase<T extends Metric>
extends MetricsInterceptorBase.WithPostCompletion<T> {
    private long startNanos;

    InterceptorTimedBase(Class<? extends Annotation> annotationType, Class<T> metricType) {
        super(annotationType, metricType);
    }

    @Override
    void preInvoke(T metric) {
        this.startNanos = System.nanoTime();
    }

    Duration duration() {
        return Duration.ofNanos(this.durationNanoseconds());
    }

    long durationNanoseconds() {
        return System.nanoTime() - this.startNanos;
    }
}

