/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.Builder;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.resumable.ResumableSupport;
import io.helidon.config.Config;
import io.helidon.http.HeaderNames;
import io.helidon.http.Status;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.JaxRsService;
import io.helidon.microprofile.server.RoutingConfiguration;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.context.ContextFeature;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.observe.ObserveFeature;
import io.helidon.webserver.observe.ObserveFeatureConfig;
import io.helidon.webserver.observe.spi.Observer;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.staticcontent.StaticContentConfig;
import io.helidon.webserver.staticcontent.StaticContentService;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;

public class ServerCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(ServerCdiExtension.class.getName());
    private static final System.Logger STARTUP_LOGGER = System.getLogger("io.helidon.microprofile.startup.server");
    private static final AtomicBoolean IN_PROGRESS_OR_RUNNING = new AtomicBoolean();
    private final Map<Bean<?>, RoutingConfiguration> serviceBeans = Collections.synchronizedMap(new IdentityHashMap());
    private final List<HttpRouting.Builder> routingsWithKPIMetrics = new ArrayList<HttpRouting.Builder>();
    private WebServerConfig.Builder serverBuilder = (WebServerConfig.Builder)((WebServerConfig.Builder)((WebServerConfig.Builder)WebServer.builder().shutdownHook(false)).featuresDiscoverServices(false)).port(7001);
    private ObserveFeatureConfig.Builder observeBuilder = ObserveFeature.builder();
    private HttpRouting.Builder routingBuilder = HttpRouting.builder();
    private Map<String, HttpRouting.Builder> namedRoutings = new HashMap<String, HttpRouting.Builder>();
    private Map<String, Router.Builder> namedRouters = new HashMap<String, Router.Builder>();
    private String basePath;
    private Config config;
    private WebServer webserver;
    private volatile int port;
    private volatile String listenHost = "0.0.0.0";
    private volatile boolean started;
    private Context context;

    public HttpRouting.Builder serverRoutingBuilder() {
        return this.routingBuilder;
    }

    public HttpRouting.Builder serverNamedRoutingBuilder(String name) {
        if ("@default".equals(name)) {
            return this.serverRoutingBuilder();
        }
        return this.namedRoutings.computeIfAbsent(name, routeName -> HttpRouting.builder());
    }

    public void addRouting(Builder<?, ? extends Routing> routing) {
        this.serverBuilder.addRouting(routing);
    }

    public void addRouting(Builder<?, ? extends Routing> routing, String socketName, boolean required, String appName) {
        if ("@default".equals(socketName)) {
            this.serverBuilder.addRouting(routing);
        } else {
            boolean hasRouting = this.serverBuilder.sockets().containsKey(socketName);
            if (required && !hasRouting) {
                throw new IllegalStateException("Application requires configured listener (socket name) " + socketName + " to exist, yet such a socket is not configured for web server for app: " + appName);
            }
            if (!hasRouting) {
                LOGGER.log(System.Logger.Level.INFO, "Routing " + socketName + " does not exist, using default routing instead for " + appName);
                this.serverBuilder.addRouting(routing);
            } else {
                this.namedRouters.computeIfAbsent(socketName, it -> Router.builder()).addRouting(routing);
            }
        }
    }

    public void addObserver(Observer observer) {
        this.observeBuilder.addObserver(observer);
    }

    public String host() {
        return this.listenHost;
    }

    public int port() {
        return this.port;
    }

    public int port(String name) {
        return this.webserver.port(name);
    }

    public boolean started() {
        return this.started;
    }

    public void basePath(String basePath) {
        this.basePath = basePath;
    }

    public void addFeature(ServerFeature feature) {
        this.serverBuilder.addFeature(feature);
    }

    HttpRouting.Builder routingBuilder(Optional<String> namedRouting, boolean routingNameRequired, String appName) {
        if (namedRouting.isPresent()) {
            String socket = namedRouting.get();
            if (!this.serverBuilder.sockets().containsKey(socket)) {
                if (routingNameRequired) {
                    throw new IllegalStateException("Application " + appName + " requires routing " + socket + " to exist, yet such a socket is not configured for web server");
                }
                LOGGER.log(System.Logger.Level.INFO, "Routing " + socket + " does not exist, using default routing for application " + appName);
                return this.serverRoutingBuilder();
            }
            return this.serverNamedRoutingBuilder(socket);
        }
        return this.serverRoutingBuilder();
    }

    WebServerConfig.Builder serverBuilder() {
        return this.serverBuilder;
    }

    void context(Context context) {
        this.context = context;
    }

    void listenHost(String listenHost) {
        this.listenHost = listenHost;
    }

    private static List<Bean<?>> prioritySort(Set<Bean<?>> beans) {
        ArrayList prioritized = new ArrayList(beans);
        prioritized.sort((o1, o2) -> {
            int firstPriority = ServerCdiExtension.priority(o1.getBeanClass());
            int secondPriority = ServerCdiExtension.priority(o2.getBeanClass());
            return Integer.compare(firstPriority, secondPriority);
        });
        return prioritized;
    }

    private static int priority(Class<?> aClass) {
        Priority prio = aClass.getAnnotation(Priority.class);
        return null == prio ? 5000 : prio.value();
    }

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.serverBuilder.config((io.helidon.common.config.Config)config.get("server"));
        this.observeBuilder.config((io.helidon.common.config.Config)config.get("server.features.observe"));
        this.config = config;
        if (!config.get("server.features.context").exists()) {
            this.serverBuilder.addFeature((ServerFeature)ContextFeature.create());
        }
    }

    private void registerKpiMetricsDeferrableRequestHandlers(@Observes @Priority(value=1000) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        JaxRsCdiExtension jaxRs = (JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class);
        List<JaxRsApplication> jaxRsApplications = jaxRs.applicationsToRun();
        jaxRsApplications.forEach(it -> this.registerKpiMetricsDeferrableRequestContextSetterHandler(jaxRs, (JaxRsApplication)it));
    }

    private void recordMethodProducedServices(@Observes ProcessProducerMethod<? extends HttpService, ?> ppm) {
        Method m = ppm.getAnnotatedProducerMethod().getJavaMember();
        String contextKey = m.getDeclaringClass().getName() + "." + m.getName();
        this.serviceBeans.put(ppm.getBean(), new RoutingConfiguration(ppm.getAnnotated(), contextKey));
    }

    private void recordFieldProducedServices(@Observes ProcessProducerField<? extends HttpService, ?> ppf) {
        Field f = ppf.getAnnotatedProducerField().getJavaMember();
        String contextKey = f.getDeclaringClass().getName() + "." + f.getName();
        this.serviceBeans.put(ppf.getBean(), new RoutingConfiguration(ppf.getAnnotated(), contextKey));
    }

    private void recordBeanServices(@Observes ProcessManagedBean<? extends HttpService> pmb) {
        Class cls = pmb.getAnnotatedBeanClass().getJavaClass();
        this.serviceBeans.put(pmb.getBean(), new RoutingConfiguration(pmb.getAnnotated(), cls.getName()));
    }

    private void registerKpiMetricsDeferrableRequestContextSetterHandler(JaxRsCdiExtension jaxRs, JaxRsApplication applicationMeta) {
        boolean routingNameRequired;
        Optional<String> namedRouting = jaxRs.findNamedRouting(this.config, applicationMeta);
        HttpRouting.Builder routing = this.routingBuilder(namedRouting, routingNameRequired = jaxRs.isNamedRoutingRequired(this.config, applicationMeta), applicationMeta.appName());
        if (!this.routingsWithKPIMetrics.contains(routing)) {
            this.routingsWithKPIMetrics.add(routing);
            routing.any(new Handler[]{KeyPerformanceIndicatorSupport.DeferrableRequestContext.CONTEXT_SETTING_HANDLER});
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("Adding deferrable request KPI metrics context for routing with name '%s'", namedRouting.orElse("<unnamed>")));
            }
        }
    }

    private void startServer(@Observes @Priority(value=4100) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        if (!IN_PROGRESS_OR_RUNNING.compareAndSet(false, true)) {
            throw new IllegalStateException("There is another builder in progress, or another Server running. You cannot run more than one in parallel");
        }
        this.registerDefaultRedirect();
        this.registerStaticContent();
        this.registerWebServerServices(beanManager);
        this.registerJaxRsApplications(beanManager);
        this.serverBuilder.addFeature((ServerFeature)this.observeBuilder.build());
        this.serverBuilder.routing(this.routingBuilder);
        this.namedRouters.forEach((name, routerBuilder) -> {
            ListenerConfig listenerConfig = (ListenerConfig)this.serverBuilder.sockets().get(name);
            ListenerConfig.Builder builder = listenerConfig == null ? ListenerConfig.builder() : ListenerConfig.builder((ListenerConfig)listenerConfig);
            builder.addRoutings(routerBuilder.routings());
            this.serverBuilder.putSocket(name, builder.build());
        });
        this.namedRoutings.forEach((name, value) -> {
            ListenerConfig listenerConfig = (ListenerConfig)this.serverBuilder.sockets().get(name);
            ListenerConfig.Builder builder = listenerConfig == null ? ListenerConfig.builder() : ListenerConfig.builder((ListenerConfig)listenerConfig);
            builder.routing(value);
            this.serverBuilder.putSocket(name, builder.build());
        });
        Set socketNames = this.serverBuilder.sockets().keySet();
        for (String socketName : socketNames) {
            if ("@default".equals(socketName) || this.namedRoutings.get(socketName) != null || this.observeBuilder.sockets().contains(socketName)) continue;
            this.serverBuilder.routing(socketName, this.serverBuilder.routing().orElseGet(HttpRouting::builder).copy());
        }
        if (this.context == null) {
            this.context = Contexts.context().orElse(Context.builder().id("helidon-mp").build());
        }
        this.webserver = this.serverBuilder.build();
        try {
            this.webserver.start();
            this.started = true;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to start webserver", (Throwable)e);
        }
        this.port = this.webserver.port();
        ResumableSupport.get().checkpointResumeOnStartup();
        long initializationElapsedTime = ResumableSupport.get().uptime();
        String protocol = "http" + (this.webserver.hasTls() ? "s" : "");
        String host = "0.0.0.0".equals(this.listenHost) ? "localhost" : this.listenHost;
        String note = "0.0.0.0".equals(this.listenHost) ? " (and all other host addresses)" : "";
        LOGGER.log(System.Logger.Level.INFO, () -> "Server started on " + protocol + "://" + host + ":" + this.port + note + " in " + initializationElapsedTime + " milliseconds (since JVM startup).");
        this.serverBuilder = null;
        this.observeBuilder = null;
        this.routingBuilder = null;
        this.namedRoutings = null;
        this.namedRouters = null;
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Server created");
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        event.addBean().qualifiers(Set.of(Default.Literal.INSTANCE, Any.Literal.INSTANCE)).addTransitiveTypeClosure(ServerRequest.class).scope(RequestScoped.class).createWith(cc -> Contexts.context().flatMap(c -> c.get(ServerRequest.class)).orElseThrow(() -> new CreationException("Unable to retrieve ServerRequest from context")));
        event.addBean().qualifiers(Set.of(Default.Literal.INSTANCE, Any.Literal.INSTANCE)).addTransitiveTypeClosure(ServerResponse.class).scope(RequestScoped.class).createWith(cc -> Contexts.context().flatMap(c -> c.get(ServerResponse.class)).orElseThrow(() -> new CreationException("Unable to retrieve ServerResponse from context")));
    }

    private void registerJaxRsApplications(BeanManager beanManager) {
        JaxRsCdiExtension jaxRs = (JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class);
        List<JaxRsApplication> jaxRsApplications = jaxRs.applicationsToRun();
        if (jaxRsApplications.isEmpty()) {
            LOGGER.log(System.Logger.Level.WARNING, "There are no JAX-RS applications or resources. Maybe you forgot META-INF/beans.xml file?");
        } else {
            InjectionManager shared;
            boolean singleManager = this.config.get("server.single-injection-manager").asBoolean().asOptional().orElse(false);
            InjectionManager injectionManager = shared = jaxRsApplications.size() == 1 || singleManager ? null : Injections.createInjectionManager();
            if (shared != null) {
                List instances = jaxRsApplications.stream().flatMap(app -> app.applicationClass().stream()).flatMap(c -> CDI.current().select(c, new Annotation[0]).stream()).toList();
                instances.stream().flatMap(i -> i.getClasses().stream()).filter(ParamConverterProvider.class::isAssignableFrom).forEach(c -> shared.register(Bindings.serviceAsContract((Class)c).to(ParamConverterProvider.class)));
                instances.stream().flatMap(i -> i.getSingletons().stream()).filter(s -> s instanceof ParamConverterProvider).forEach(s -> shared.register((Binding)Bindings.service((Object)s)));
            }
            jaxRsApplications.forEach(it -> this.addApplication(jaxRs, (JaxRsApplication)it, shared));
        }
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Registered jersey application(s)");
    }

    private void registerDefaultRedirect() {
        Optional.ofNullable(this.basePath).or(() -> this.config.get("server.base-path").asString().asOptional()).ifPresent(basePath -> this.routingBuilder.any("/", new Handler[]{(req, res) -> {
            res.status(Status.MOVED_PERMANENTLY_301);
            res.headers().set(HeaderNames.LOCATION, new String[]{basePath});
            res.send();
        }}));
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Builders ready");
    }

    private void registerStaticContent() {
        Config rootConfig = (Config)ConfigProvider.getConfig();
        Config config = rootConfig.get("server.static");
        if (config.exists()) {
            LOGGER.log(System.Logger.Level.WARNING, "Configuration of static content through \"server.static\" is now deprecated. Please use \"server.features.static-content\", with sub-keys \"path\" and/or \"classpath\" containing a list of handlers. At least \"context\" and \"location\" should be provided for each handler. Location for classpath is the resource location with static content, for path it is the location on file system with the root of static content. For advanced configuration such as in-memory caching, temporary storage setup etc. kindly see our config reference for \"StaticContentFeature\" in documentation.");
        }
        config.get("classpath").ifExists(this::registerClasspathStaticContent);
        config.get("path").ifExists(this::registerPathStaticContent);
        Config featureConfig = rootConfig.get("server.features.static-content");
        if (featureConfig.exists()) {
            StaticContentConfig.Builder builder = (StaticContentConfig.Builder)StaticContentConfig.builder().config((io.helidon.common.config.Config)featureConfig);
            if (builder.welcome().isEmpty()) {
                builder.welcome("index.html");
            }
            this.addFeature((ServerFeature)builder.build());
        }
    }

    private void registerPathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentService.FileSystemBuilder pBuilder = StaticContentService.builder((Path)((Path)config.get("location").as(Path.class).get()));
        pBuilder.welcomeFileName((String)config.get("welcome").asString().orElse((Object)"index.html"));
        StaticContentService staticContent = pBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new HttpService[]{staticContent});
        } else {
            Supplier<StaticContentService> ms = () -> staticContent;
            this.routingBuilder.register(ms);
        }
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Static path");
    }

    private void registerClasspathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentService.ClassPathBuilder cpBuilder = StaticContentService.builder((String)((String)config.get("location").asString().get()));
        cpBuilder.welcomeFileName((String)config.get("welcome").asString().orElse((Object)"index.html"));
        config.get("tmp-dir").as(Path.class).ifPresent(arg_0 -> ((StaticContentService.ClassPathBuilder)cpBuilder).tmpDir(arg_0));
        config.get("cache-in-memory").asList(String.class).stream().flatMap(Collection::stream).forEach(arg_0 -> ((StaticContentService.ClassPathBuilder)cpBuilder).addCacheInMemory(arg_0));
        StaticContentService staticContent = cpBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new HttpService[]{staticContent});
        } else {
            this.routingBuilder.register(new HttpService[]{staticContent});
        }
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Static classpath");
    }

    private void stopServer(@Observes @Priority(value=0) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        try {
            if (this.started) {
                this.doStop();
            }
        }
        finally {
            IN_PROGRESS_OR_RUNNING.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        if (null == this.webserver || !this.started) {
            return;
        }
        long beforeT = System.nanoTime();
        try {
            this.webserver.stop();
            this.started = false;
        }
        finally {
            long t = TimeUnit.MILLISECONDS.convert(System.nanoTime() - beforeT, TimeUnit.NANOSECONDS);
            LOGGER.log(System.Logger.Level.INFO, () -> "Server stopped in " + t + " milliseconds.");
        }
    }

    private void addApplication(JaxRsCdiExtension jaxRs, JaxRsApplication applicationMeta, InjectionManager injectionManager) {
        LOGGER.log(System.Logger.Level.INFO, "Registering JAX-RS Application: " + applicationMeta.appName());
        Optional<String> contextRoot = jaxRs.findContextRoot(this.config, applicationMeta);
        Optional<String> namedRouting = jaxRs.findNamedRouting(this.config, applicationMeta);
        boolean routingNameRequired = jaxRs.isNamedRoutingRequired(this.config, applicationMeta);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Application " + applicationMeta.appName() + ", class: " + applicationMeta.appClassName() + ", contextRoot: " + String.valueOf(contextRoot) + ", namedRouting: " + String.valueOf(namedRouting) + ", routingNameRequired: " + routingNameRequired);
        }
        HttpRouting.Builder routing = this.routingBuilder(namedRouting, routingNameRequired, applicationMeta.appName());
        JaxRsService jerseyHandler = jaxRs.toJerseySupport(applicationMeta, injectionManager);
        if (contextRoot.isPresent()) {
            String contextRootString = contextRoot.get();
            LOGGER.log(System.Logger.Level.DEBUG, () -> "JAX-RS application " + applicationMeta.appName() + " registered on '" + contextRootString + "'");
            if (contextRootString.endsWith("/")) {
                routing.register(contextRootString.substring(0, contextRootString.length() - 1), new HttpService[]{jerseyHandler});
            } else {
                routing.register(contextRootString, new HttpService[]{jerseyHandler});
            }
        } else {
            LOGGER.log(System.Logger.Level.DEBUG, () -> "JAX-RS application " + applicationMeta.appName() + " registered on '/'");
            routing.register(new HttpService[]{jerseyHandler});
        }
    }

    private void registerWebServerServices(BeanManager beanManager) {
        List<Bean<?>> beans = ServerCdiExtension.prioritySort(beanManager.getBeans(HttpService.class, new Annotation[0]));
        CreationalContext context = beanManager.createCreationalContext(null);
        Iterator<Bean<?>> iterator = beans.iterator();
        while (iterator.hasNext()) {
            Bean<?> bean;
            Bean<?> objBean = bean = iterator.next();
            HttpService service = (HttpService)objBean.create(context);
            this.registerWebServerService(this.serviceBeans.remove(bean), service);
        }
        STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Registered WebServer services");
    }

    private void registerWebServerService(RoutingConfiguration routingConf, HttpService service) {
        String path = routingConf.routingPath(this.config);
        String routingName = routingConf.routingName(this.config);
        boolean routingNameRequired = routingConf.required(this.config);
        HttpRouting.Builder routing = this.findRouting(routingConf.configContext(), routingName, routingNameRequired);
        if (null == path || "/".equals(path)) {
            routing.register(new HttpService[]{service});
        } else {
            routing.register(path, new HttpService[]{service});
        }
    }

    private HttpRouting.Builder findRouting(String className, String routingName, boolean routingNameRequired) {
        if (null == routingName || "@default".equals(routingName)) {
            return this.serverRoutingBuilder();
        }
        if (!this.serverBuilder.sockets().containsKey(routingName)) {
            if (routingNameRequired) {
                throw new IllegalStateException(className + " requires routing " + routingName + ", yet such a named socket is not configured for web server");
            }
            LOGGER.log(System.Logger.Level.DEBUG, () -> className + " is configured with named routing " + routingName + ". Such a routing is not configured, this service/application will run on default socket.");
            return this.serverRoutingBuilder();
        }
        return this.serverNamedRoutingBuilder(routingName);
    }
}

