/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common;

import io.helidon.security.providers.common.EvictableCache;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class EvictableCacheImpl<K, V>
implements EvictableCache<K, V> {
    static final EvictableCache<?, ?> NO_CACHE = new EvictableCache<Object, Object>(){};
    private static final int EVICT_THREAD_COUNT = 1;
    private static final ScheduledThreadPoolExecutor EXECUTOR;
    private final ConcurrentHashMap<K, CacheRecord<K, V>> cacheMap = new ConcurrentHashMap();
    private final long cacheTimeoutNanos;
    private final long overallTimeoutNanos;
    private final long cacheMaxSize;
    private final long evictParallelismThreshold;
    private final ScheduledFuture<?> evictionFuture;
    private final BiFunction<K, V, Boolean> evictor;

    EvictableCacheImpl(EvictableCache.Builder<K, V> builder) {
        this.cacheMaxSize = builder.cacheMaxSize();
        this.cacheTimeoutNanos = TimeUnit.NANOSECONDS.convert(builder.cacheTimeout(), builder.cacheTimeoutUnit());
        this.overallTimeoutNanos = TimeUnit.NANOSECONDS.convert(builder.overallTimeout(), builder.overallTimeoutUnit());
        this.evictParallelismThreshold = builder.parallelismThreshold();
        this.evictor = builder.evictor();
        this.evictionFuture = EXECUTOR.scheduleAtFixedRate(this::evict, builder.cacheEvictDelay(), builder.cacheEvictPeriod(), builder.cacheEvictTimeUnit());
        EXECUTOR.setRemoveOnCancelPolicy(true);
    }

    @Override
    public Optional<V> remove(K key) {
        CacheRecord<K, V> removed = this.cacheMap.remove(key);
        if (removed == null) {
            return Optional.empty();
        }
        return this.validate(removed).map(CacheRecord::getValue);
    }

    @Override
    public Optional<V> get(K key) {
        return this.getRecord(key).flatMap(this::validate).map(this::accessed).map(CacheRecord::getValue);
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public Optional<V> computeValue(K key, Supplier<Optional<V>> valueSupplier) {
        try {
            return this.doComputeValue(key, valueSupplier);
        }
        catch (CacheFullException e) {
            return valueSupplier.get();
        }
    }

    @Override
    public void close() {
        this.evictionFuture.cancel(true);
        this.cacheMap.clear();
    }

    void evict() {
        this.cacheMap.forEachKey(this.evictParallelismThreshold, key -> this.cacheMap.compute(key, (key1, cacheRecord) -> {
            if (cacheRecord == null || this.evictor.apply(cacheRecord.getKey(), cacheRecord.getValue()).booleanValue()) {
                return null;
            }
            if (cacheRecord.isValid(this.cacheTimeoutNanos, this.overallTimeoutNanos)) {
                return cacheRecord;
            }
            return null;
        }));
    }

    private CacheRecord<K, V> accessed(CacheRecord<K, V> record) {
        record.accessed();
        return record;
    }

    private Optional<CacheRecord<K, V>> validate(CacheRecord<K, V> record) {
        if (record.isValid(this.cacheTimeoutNanos, this.overallTimeoutNanos) && !this.evictor.apply(record.getKey(), record.getValue()).booleanValue()) {
            return Optional.of(record);
        }
        this.cacheMap.remove(record.key);
        return Optional.empty();
    }

    private Optional<V> doComputeValue(K key, Supplier<Optional<V>> valueSupplier) {
        CacheRecord record = this.cacheMap.compute(key, (s, cacheRecord) -> {
            if (cacheRecord != null && cacheRecord.isValid(this.cacheTimeoutNanos, this.overallTimeoutNanos)) {
                return this.accessed((CacheRecord<K, V>)cacheRecord);
            }
            if ((long)this.cacheMap.size() >= this.cacheMaxSize) {
                throw new CacheFullException();
            }
            return ((Optional)valueSupplier.get()).map(v -> new CacheRecord<Object, Object>(key, v)).orElse(null);
        });
        if (record == null) {
            return Optional.empty();
        }
        return Optional.of(record.value);
    }

    private Optional<CacheRecord<K, V>> getRecord(K key) {
        return Optional.ofNullable(this.cacheMap.get(key));
    }

    static {
        ThreadFactory jf = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r, this.getClass().getSimpleName() + "-cachePurge_" + this.counter.getAndIncrement());
                newThread.setDaemon(true);
                return newThread;
            }
        };
        EXECUTOR = new ScheduledThreadPoolExecutor(1, jf);
    }

    private static final class CacheRecord<K, V> {
        private final K key;
        private final V value;
        private final long created = System.nanoTime();
        private volatile long lastAccess = System.nanoTime();

        private CacheRecord(K key, V value) {
            this.key = key;
            this.value = value;
        }

        private void accessed() {
            this.lastAccess = System.nanoTime();
        }

        private boolean isValid(long timeoutNanos, long overallTimeout) {
            long nano = System.nanoTime();
            return nano - this.created < overallTimeout && nano - this.lastAccess < timeoutNanos;
        }

        private K getKey() {
            return this.key;
        }

        private V getValue() {
            return this.value;
        }
    }

    private static final class CacheFullException
    extends RuntimeException {
        private CacheFullException() {
        }
    }
}

