/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.webclient.api.DefaultAddressLookupFinder;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public enum DnsAddressLookup {
    IPV4(new Ipv4Only()),
    IPV6(new Ipv6Only()),
    IPV4_PREFERRED(new Ipv4Preferred()),
    IPV6_PREFERRED(new Ipv6Preferred());

    private static final InetAddressComparator COMPARATOR;
    private final Function<InetAddress[], InetAddress[]> function;

    public static DnsAddressLookup defaultLookup() {
        return DefaultAddressLookupFinder.defaultDnsAddressLookup();
    }

    private DnsAddressLookup(Function<InetAddress[], InetAddress[]> function) {
        this.function = function;
    }

    public InetAddress[] filter(InetAddress[] addresses) {
        return this.function.apply(addresses);
    }

    private static boolean isIPv4(InetAddress address) {
        return address.getAddress().length == 4;
    }

    private static boolean isIPv6(InetAddress address) {
        return address.getAddress().length == 16;
    }

    static {
        COMPARATOR = new InetAddressComparator();
    }

    private static class Ipv4Only
    implements Function<InetAddress[], InetAddress[]> {
        private Ipv4Only() {
        }

        @Override
        public InetAddress[] apply(InetAddress[] addresses) {
            return (InetAddress[])Arrays.stream(addresses).filter(DnsAddressLookup::isIPv4).toArray(InetAddress[]::new);
        }
    }

    private static class Ipv6Only
    implements Function<InetAddress[], InetAddress[]> {
        private Ipv6Only() {
        }

        @Override
        public InetAddress[] apply(InetAddress[] addresses) {
            return (InetAddress[])Arrays.stream(addresses).filter(DnsAddressLookup::isIPv6).toArray(InetAddress[]::new);
        }
    }

    private static class Ipv4Preferred
    implements Function<InetAddress[], InetAddress[]> {
        private Ipv4Preferred() {
        }

        @Override
        public InetAddress[] apply(InetAddress[] addresses) {
            InetAddress[] copy = Arrays.copyOfRange(addresses, 0, addresses.length);
            Arrays.sort(copy, COMPARATOR);
            return copy;
        }
    }

    private static class Ipv6Preferred
    implements Function<InetAddress[], InetAddress[]> {
        private Ipv6Preferred() {
        }

        @Override
        public InetAddress[] apply(InetAddress[] addresses) {
            InetAddress[] copy = Arrays.copyOfRange(addresses, 0, addresses.length);
            Arrays.sort(copy, (o1, o2) -> COMPARATOR.compare((InetAddress)o1, (InetAddress)o2) * -1);
            return copy;
        }
    }

    private static final class InetAddressComparator
    implements Comparator<InetAddress>,
    Serializable {
        private InetAddressComparator() {
        }

        @Override
        public int compare(InetAddress o1, InetAddress o2) {
            if (DnsAddressLookup.isIPv4(o1)) {
                if (DnsAddressLookup.isIPv4(o2)) {
                    return 0;
                }
                return -1;
            }
            if (DnsAddressLookup.isIPv6(o2)) {
                return 0;
            }
            return 1;
        }
    }
}

