/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.webserver.cors.CorsConfigBlueprint;
import io.helidon.webserver.cors.CorsConfigSupport;
import io.helidon.webserver.cors.CorsFeature;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.cors.CorsConfigBlueprint")
public interface CorsConfig
extends CorsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CorsConfig instance) {
        return (Builder)CorsConfig.builder().from(instance);
    }

    public static CorsConfig create(Config config) {
        return ((Builder)CorsConfig.builder().config(config)).buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, CorsConfig>
    implements io.helidon.common.Builder<Builder, CorsFeature> {
        private Builder() {
        }

        public CorsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CorsConfigImpl(this);
        }

        public CorsFeature build() {
            return CorsFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CorsConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<String> sockets = new LinkedHashSet<String>();
        private Boolean enabled;
        private Config config;
        private double weight = 850.0;
        private String name = "cors";

        protected BuilderBase() {
        }

        public BUILDER from(CorsConfig prototype) {
            this.weight(prototype.weight());
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            this.enabled(prototype.enabled());
            this.config = prototype.config().orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.weight(builder.weight());
            this.addSockets(builder.sockets);
            this.name(builder.name());
            builder.enabled().ifPresent(this::enabled);
            builder.config().ifPresent(config -> this.config((Config)config));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocket(String socket) {
            Objects.requireNonNull(socket);
            this.sockets.add(socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public double weight() {
            return this.weight;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public Optional<Boolean> enabled() {
            return Optional.ofNullable(this.enabled);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "CorsConfigBuilder{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",enabled=" + this.enabled + ",config=" + String.valueOf(this.config) + "}";
        }

        protected void preBuildPrototype() {
            new CorsConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.enabled == null) {
                collector.fatal(this.getClass(), "Property \"enabled\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class CorsConfigImpl
        implements CorsConfig,
        Supplier<CorsFeature> {
            private final boolean enabled;
            private final double weight;
            private final Optional<Config> config;
            private final Set<String> sockets;
            private final String name;

            protected CorsConfigImpl(BuilderBase<?, ?> builder) {
                this.weight = builder.weight();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.name = builder.name();
                this.enabled = builder.enabled().get();
                this.config = builder.config();
            }

            public CorsFeature build() {
                return CorsFeature.create(this);
            }

            @Override
            public CorsFeature get() {
                return this.build();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<Config> config() {
                return this.config;
            }

            public String toString() {
                return "CorsConfig{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",enabled=" + this.enabled + ",config=" + String.valueOf(this.config) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CorsConfig)) {
                    return false;
                }
                CorsConfig other = (CorsConfig)o;
                return this.weight == other.weight() && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name()) && this.enabled == other.enabled() && Objects.equals(this.config, other.config());
            }

            public int hashCode() {
                return Objects.hash(this.weight, this.sockets, this.name, this.enabled, this.config);
            }
        }
    }
}

