/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.cors.CrossOriginConfig;
import io.helidon.webserver.cors.CorsSupport;
import io.helidon.webserver.http.Handler;

public class CorsEnabledServiceHelper {
    public static final String CORS_CONFIG_KEY = "cors";
    private static final Handler NO_OP_HANDLER = (req, res) -> res.next();
    private static final System.Logger LOGGER = System.getLogger(CorsEnabledServiceHelper.class.getName());
    private final String serviceName;
    private final CrossOriginConfig crossOriginConfig;

    private CorsEnabledServiceHelper(String serviceName, CrossOriginConfig crossOriginConfig) {
        this.serviceName = serviceName;
        this.crossOriginConfig = crossOriginConfig;
    }

    public static CorsEnabledServiceHelper create(String serviceName, CrossOriginConfig crossOriginConfig) {
        if (crossOriginConfig == null) {
            crossOriginConfig = CorsEnabledServiceHelper.defaultCrossOriginConfig();
        }
        return new CorsEnabledServiceHelper(serviceName, crossOriginConfig);
    }

    public static CorsEnabledServiceHelper create(String serviceName) {
        return new CorsEnabledServiceHelper(serviceName, CorsEnabledServiceHelper.defaultCrossOriginConfig());
    }

    public Handler processor() {
        CorsSupport.Builder builder = (CorsSupport.Builder)CorsSupport.builder().name(this.serviceName);
        if (!this.crossOriginConfig.isEnabled()) {
            LOGGER.log(System.Logger.Level.TRACE, () -> String.format("CORS is disabled for service %s", this.serviceName));
            return NO_OP_HANDLER;
        }
        builder.addCrossOrigin(this.crossOriginConfig);
        LOGGER.log(System.Logger.Level.TRACE, String.format("CORS is configured for service %s with %s", this.serviceName, this.crossOriginConfig));
        return builder.build();
    }

    private static CrossOriginConfig defaultCrossOriginConfig() {
        return CrossOriginConfig.builder().allowMethods(new String[]{"GET", "HEAD", "OPTIONS"}).build();
    }
}

