/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.common.config.Config;
import io.helidon.webserver.cors.CorsConfig;
import io.helidon.webserver.cors.CorsHttpFeature;
import io.helidon.webserver.cors.CorsSupport;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.spi.ServerFeature;
import java.util.HashSet;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=CorsConfig.class)
public class CorsFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<CorsConfig> {
    public static final double WEIGHT = 850.0;
    static final String CORS_ID = "cors";
    private final CorsConfig config;

    CorsFeature(CorsConfig config) {
        this.config = config;
    }

    public static CorsConfig.Builder builder() {
        return CorsConfig.builder();
    }

    public static CorsFeature create(CorsConfig config) {
        return new CorsFeature(config);
    }

    public static CorsFeature create(Consumer<CorsConfig.Builder> builderConsumer) {
        return ((CorsConfig.Builder)CorsFeature.builder().update(builderConsumer)).build();
    }

    public static CorsFeature create() {
        return CorsFeature.builder().build();
    }

    public static CorsFeature create(Config config) {
        return ((CorsConfig.Builder)CorsFeature.builder().config(config)).build();
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.config.enabled()) {
            return;
        }
        HashSet<String> sockets = new HashSet<String>(this.config.sockets());
        if (sockets.isEmpty()) {
            sockets.addAll(featureContext.sockets());
            sockets.add("@default");
        }
        Config corsConfig = this.config.config().orElseGet(Config::empty).root().get(CORS_ID);
        for (String socket : sockets) {
            featureContext.socket(socket).httpRouting().addFeature((HttpFeature)new CorsHttpFeature(this.config.weight(), ((CorsSupport.Builder)((CorsSupport.Builder)CorsSupport.builder().config(corsConfig)).name("cors-" + socket)).build()));
        }
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return CORS_ID;
    }

    public CorsConfig prototype() {
        return this.config;
    }

    public double weight() {
        return this.config.weight();
    }
}

