/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.common.uri.UriInfo;
import io.helidon.cors.CorsRequestAdapter;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.WritableHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class CorsServerRequestAdapter
implements CorsRequestAdapter<ServerRequest> {
    static final Set<HeaderName> HEADERS_FOR_CORS_DIAGNOSTICS = Set.of(HeaderNames.ORIGIN, HeaderNames.HOST, HeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    private final ServerRequest request;
    private final ServerResponse response;
    private final ServerRequestHeaders headers;

    CorsServerRequestAdapter(ServerRequest req, ServerResponse res) {
        this.request = req;
        this.response = res;
        this.headers = req.headers();
    }

    public UriInfo requestedUri() {
        return this.request.requestedUri();
    }

    public String path() {
        return this.request.path().path();
    }

    public Optional<String> firstHeader(HeaderName key) {
        if (this.headers.contains(key)) {
            return Optional.of((String)this.headers.get(key).get());
        }
        return Optional.empty();
    }

    public boolean headerContainsKey(HeaderName key) {
        return this.headers.contains(key);
    }

    public List<String> allHeaders(HeaderName key) {
        return this.headers.all(key, List::of);
    }

    public String method() {
        return this.request.prologue().method().text();
    }

    public void next() {
        this.response.next();
    }

    public ServerRequest request() {
        return this.request;
    }

    public String toString() {
        return String.format("RequestAdapterSe{path=%s, method=%s, headers=%s}", this.path(), this.method(), this.headersDisplay());
    }

    private Headers headersDisplay() {
        WritableHeaders result = WritableHeaders.create();
        HEADERS_FOR_CORS_DIAGNOSTICS.forEach(headerName -> {
            if (this.headers.contains(headerName)) {
                result.add(this.headers.get(headerName));
            }
        });
        return result;
    }
}

