/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.cors.CorsResponseAdapter;
import io.helidon.http.HeaderName;
import io.helidon.http.Status;
import io.helidon.webserver.http.ServerResponse;

class CorsServerResponseAdapter
implements CorsResponseAdapter<ServerResponse> {
    private final ServerResponse serverResponse;

    CorsServerResponseAdapter(ServerResponse serverResponse) {
        this.serverResponse = serverResponse;
    }

    public CorsServerResponseAdapter header(HeaderName key, String value) {
        this.serverResponse.header(key, new String[]{value});
        return this;
    }

    public CorsServerResponseAdapter header(HeaderName key, Object value) {
        this.serverResponse.header(key, new String[]{value.toString()});
        return this;
    }

    public ServerResponse forbidden(String message) {
        this.serverResponse.status(Status.create((int)Status.FORBIDDEN_403.code(), (String)message));
        return this.serverResponse;
    }

    public ServerResponse ok() {
        this.serverResponse.status(Status.OK_200);
        return this.serverResponse;
    }

    public int status() {
        return this.serverResponse.status().code();
    }
}

