/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.common.config.Config;
import io.helidon.cors.CorsRequestAdapter;
import io.helidon.cors.CorsResponseAdapter;
import io.helidon.cors.CorsSupportBase;
import io.helidon.cors.CorsSupportHelper;
import io.helidon.webserver.cors.CorsServerRequestAdapter;
import io.helidon.webserver.cors.CorsServerResponseAdapter;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.Optional;

public class CorsSupport
extends CorsSupportBase<ServerRequest, ServerResponse, CorsSupport, Builder>
implements HttpService,
Handler {
    private CorsSupport(Builder builder) {
        super((CorsSupportBase.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CorsSupport create() {
        return CorsSupport.builder().build();
    }

    public static CorsSupport create(Config config) {
        return ((Builder)CorsSupport.builder().config(config)).build();
    }

    public static CorsSupport createMapped(Config config) {
        return ((Builder)CorsSupport.builder().mappedConfig(config)).build();
    }

    public void routing(HttpRules rules) {
        if (this.helper().isActive()) {
            rules.any(new Handler[]{this});
        }
    }

    public void handle(ServerRequest req, ServerResponse res) {
        if (!this.helper().isActive()) {
            res.next();
            return;
        }
        CorsServerRequestAdapter requestAdapter = new CorsServerRequestAdapter(req, res);
        CorsServerResponseAdapter responseAdapter = new CorsServerResponseAdapter(res);
        Optional responseOpt = this.helper().processRequest((CorsRequestAdapter)requestAdapter, (CorsResponseAdapter)responseAdapter);
        responseOpt.ifPresentOrElse(ServerResponse::send, () -> this.prepareCORSResponseAndContinue(requestAdapter, responseAdapter));
    }

    public String toString() {
        return String.format("CorsSupport[%s]{%s}", this.name(), this.describe());
    }

    private void prepareCORSResponseAndContinue(CorsRequestAdapter<ServerRequest> requestAdapter, CorsResponseAdapter<ServerResponse> responseAdapter) {
        this.helper().prepareResponse(requestAdapter, responseAdapter);
        requestAdapter.next();
    }

    protected CorsSupportHelper<ServerRequest, ServerResponse> helper() {
        return super.helper();
    }

    public static class Builder
    extends CorsSupportBase.Builder<ServerRequest, ServerResponse, CorsSupport, Builder> {
        private static int builderCount = 0;

        Builder() {
            this.name("Default " + builderCount++);
            this.requestDefaultBehaviorIfNone();
        }

        public CorsSupport build() {
            return new CorsSupport(this);
        }
    }
}

