/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.property.resolution;

import io.kotest.mpp.ReflectionKt;
import io.kotest.property.Arb;
import io.kotest.property.arbitrary.BoolsKt;
import io.kotest.property.arbitrary.BytesKt;
import io.kotest.property.arbitrary.CharKt;
import io.kotest.property.arbitrary.DoublesKt;
import io.kotest.property.arbitrary.FloatsKt;
import io.kotest.property.arbitrary.IntsKt;
import io.kotest.property.arbitrary.LongsKt;
import io.kotest.property.arbitrary.ShortsKt;
import io.kotest.property.arbitrary.StringsKt;
import io.kotest.property.resolution.ArbResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/kotest/property/resolution/CommonTypeArbResolver;", "Lio/kotest/property/resolution/ArbResolver;", "()V", "resolve", "Lio/kotest/property/Arb;", "type", "Lkotlin/reflect/KType;", "kotest-property"})
public final class CommonTypeArbResolver
implements ArbResolver {
    @NotNull
    public static final CommonTypeArbResolver INSTANCE = new CommonTypeArbResolver();

    private CommonTypeArbResolver() {
    }

    @Override
    @Nullable
    public Arb<?> resolve(@NotNull KType type) {
        Arb arb2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        KClass kClass = kClassifier instanceof KClass ? (KClass)kClassifier : null;
        if (kClass == null) {
            return null;
        }
        KClass kclass = kClass;
        switch (ReflectionKt.bestName((KClass)kclass)) {
            case "String": 
            case "java.lang.String": 
            case "kotlin.String": {
                arb2 = StringsKt.string$default(Arb.Companion, 0, 0, null, 7, null);
                break;
            }
            case "java.lang.Character": 
            case "Char": 
            case "kotlin.Char": {
                arb2 = CharKt.char$default(Arb.Companion, null, 1, null);
                break;
            }
            case "java.lang.Long": 
            case "kotlin.Long": 
            case "Long": {
                arb2 = LongsKt.long$default(Arb.Companion, null, 1, null);
                break;
            }
            case "ULong": 
            case "kotlin.ULong": {
                arb2 = LongsKt.uLong$default(Arb.Companion, null, 1, null);
                break;
            }
            case "java.lang.Integer": 
            case "Int": 
            case "kotlin.Int": {
                arb2 = IntsKt.int$default(Arb.Companion, null, 1, null);
                break;
            }
            case "kotlin.UInt": 
            case "UInt": {
                arb2 = IntsKt.uInt$default(Arb.Companion, null, 1, null);
                break;
            }
            case "java.lang.Short": 
            case "Short": 
            case "kotlin.Short": {
                arb2 = ShortsKt.short$default(Arb.Companion, (short)0, (short)0, 3, null);
                break;
            }
            case "kotlin.UShort": 
            case "UShort": {
                arb2 = ShortsKt.uShort-lwaoQsk$default(Arb.Companion, (short)0, (short)0, 3, null);
                break;
            }
            case "kotlin.Byte": 
            case "java.lang.Byte": 
            case "Byte": {
                arb2 = BytesKt.byte$default(Arb.Companion, (byte)0, (byte)0, 3, null);
                break;
            }
            case "UByte": 
            case "kotlin.UByte": {
                arb2 = BytesKt.uByte-8olNwgk$default(Arb.Companion, (byte)0, (byte)0, 3, null);
                break;
            }
            case "java.lang.Double": 
            case "kotlin.Double": 
            case "Double": {
                arb2 = DoublesKt.double$default(Arb.Companion, null, 1, null);
                break;
            }
            case "java.lang.Float": 
            case "kotlin.Float": 
            case "Float": {
                arb2 = FloatsKt.float$default(Arb.Companion, null, 1, null);
                break;
            }
            case "kotlin.Boolean": 
            case "java.lang.Boolean": 
            case "Boolean": {
                arb2 = BoolsKt.boolean(Arb.Companion);
                break;
            }
            default: {
                arb2 = null;
            }
        }
        return arb2;
    }
}

