/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.dml.AnnSearchParam;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.List;
import lombok.NonNull;

public class HybridSearchParam {
    private final String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final List<AnnSearchParam> searchRequests;
    private final BaseRanker ranker;
    private final int topK;
    private final List<String> outFields;
    private final long offset;
    private final int roundDecimal;
    private final ConsistencyLevelEnum consistencyLevel;
    private final String groupByFieldName;
    private final Integer groupSize;
    private final Boolean strictGroupSize;

    private HybridSearchParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.searchRequests = builder.searchRequests;
        this.ranker = builder.ranker;
        this.topK = builder.topK;
        this.outFields = builder.outFields;
        this.offset = builder.offset;
        this.roundDecimal = builder.roundDecimal;
        this.consistencyLevel = builder.consistencyLevel;
        this.groupByFieldName = builder.groupByFieldName;
        this.groupSize = builder.groupSize;
        this.strictGroupSize = builder.strictGroupSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public List<AnnSearchParam> getSearchRequests() {
        return this.searchRequests;
    }

    public BaseRanker getRanker() {
        return this.ranker;
    }

    public int getTopK() {
        return this.topK;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public Boolean getStrictGroupSize() {
        return this.strictGroupSize;
    }

    public String toString() {
        return "HybridSearchParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", partitionNames=" + this.getPartitionNames() + ", searchRequests=" + this.getSearchRequests() + ", ranker=" + this.getRanker() + ", topK=" + this.getTopK() + ", outFields=" + this.getOutFields() + ", offset=" + this.getOffset() + ", roundDecimal=" + this.getRoundDecimal() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ", groupByFieldName=" + this.getGroupByFieldName() + ", groupSize=" + this.getGroupSize() + ", strictGroupSize=" + this.getStrictGroupSize() + ")";
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private final List<AnnSearchParam> searchRequests = Lists.newArrayList();
        private BaseRanker ranker = null;
        private Integer topK;
        private final List<String> outFields = Lists.newArrayList();
        private Long offset = 0L;
        private Integer roundDecimal = -1;
        private ConsistencyLevelEnum consistencyLevel = null;
        private String groupByFieldName = null;
        private Integer groupSize = null;
        private Boolean strictGroupSize = null;

        Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder addSearchRequest(@NonNull AnnSearchParam searchParam) {
            if (searchParam == null) {
                throw new NullPointerException("searchParam is marked non-null but is null");
            }
            this.searchRequests.add(searchParam);
            return this;
        }

        public Builder withRanker(@NonNull BaseRanker ranker) {
            if (ranker == null) {
                throw new NullPointerException("ranker is marked non-null but is null");
            }
            this.ranker = ranker;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withTopK(@NonNull Integer topK) {
            if (topK == null) {
                throw new NullPointerException("topK is marked non-null but is null");
            }
            this.topK = topK;
            return this;
        }

        public Builder withOutFields(@NonNull List<String> outFields) {
            if (outFields == null) {
                throw new NullPointerException("outFields is marked non-null but is null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        public Builder withOffset(@NonNull Long offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withRoundDecimal(@NonNull Integer decimal) {
            if (decimal == null) {
                throw new NullPointerException("decimal is marked non-null but is null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withGroupByFieldName(@NonNull String groupByFieldName) {
            if (groupByFieldName == null) {
                throw new NullPointerException("groupByFieldName is marked non-null but is null");
            }
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public Builder withGroupSize(@NonNull Integer groupSize) {
            if (groupSize == null) {
                throw new NullPointerException("groupSize is marked non-null but is null");
            }
            this.groupSize = groupSize;
            return this;
        }

        public Builder withStrictGroupSize(@NonNull Boolean strictGroupSize) {
            if (strictGroupSize == null) {
                throw new NullPointerException("strictGroupSize is marked non-null but is null");
            }
            this.strictGroupSize = strictGroupSize;
            return this;
        }

        public HybridSearchParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.ranker == null) {
                throw new ParamException("Must specify a Ranker by withRanker()");
            }
            if (this.searchRequests.isEmpty()) {
                throw new ParamException("At least a search request is required");
            }
            int vectorSize = 0;
            for (AnnSearchParam req : this.searchRequests) {
                if (vectorSize == 0) {
                    vectorSize = req.getVectors().size();
                    continue;
                }
                if (vectorSize == req.getVectors().size()) continue;
                throw new ParamException("Vector number of each AnnSearchParam must be equal");
            }
            if (this.topK <= 0) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.groupByFieldName != null && this.groupSize != null && this.groupSize <= 0) {
                throw new ParamException("GroupSize value cannot be zero or negative");
            }
            return new HybridSearchParam(this);
        }
    }
}

