/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.ipc.netty.ReactorNetty;

public interface NettyPipeline {
    public static final String LEFT = "reactor.left.";
    public static final String RIGHT = "reactor.right.";
    public static final String SslHandler = "reactor.left.sslHandler";
    public static final String SslReader = "reactor.left.sslReader";
    public static final String SslLoggingHandler = "reactor.left.sslLoggingHandler";
    public static final String ProxyHandler = "reactor.left.proxyHandler";
    public static final String ReactiveBridge = "reactor.right.reactiveBridge";
    public static final String HttpCodec = "reactor.left.httpCodec";
    public static final String HttpDecompressor = "reactor.left.decompressor";
    public static final String HttpCompressor = "reactor.left.compressor";
    public static final String HttpAggregator = "reactor.left.httpAggregator";
    public static final String HttpServerHandler = "reactor.left.httpServerHandler";
    public static final String OnChannelWriteIdle = "reactor.left.onChannelWriteIdle";
    public static final String OnChannelReadIdle = "reactor.left.onChannelReadIdle";
    public static final String ChunkedWriter = "reactor.left.chunkedWriter";
    public static final String LoggingHandler = "reactor.left.loggingHandler";
    public static final String CompressionHandler = "reactor.left.compressionHandler";

    public static ChannelInboundHandler inboundHandler(BiConsumer<? super ChannelHandlerContext, Object> handler) {
        return new ReactorNetty.ExtractorHandler(handler);
    }

    public static Object handlerTerminatedEvent() {
        return ReactorNetty.TERMINATED;
    }

    public static Object responseCompressionEvent() {
        return ReactorNetty.RESPONSE_COMPRESSION_EVENT;
    }

    public static final class SendOptionsChangeEvent {
        final Consumer<? super SendOptions> configurator;
        final Publisher<?> source;

        SendOptionsChangeEvent(Consumer<? super SendOptions> configurator, Publisher<?> source) {
            this.configurator = Objects.requireNonNull(configurator, "configurator");
            this.source = source;
        }

        public Consumer<? super SendOptions> configurator() {
            return this.configurator;
        }
    }

    public static interface SendOptions {
        public SendOptions flushOnBoundary();

        public SendOptions flushOnEach();
    }
}

