/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.audit;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Optional;

public abstract class Audit {
    private final CreateInfo createInfo;
    private Optional<SystemMessage> systemMessage;
    private UserMessage userMessage;

    public Audit(CreateInfo createInfo) {
        this.createInfo = createInfo;
    }

    public CreateInfo getCreateInfo() {
        return this.createInfo;
    }

    public void initialMessages(Optional<SystemMessage> systemMessage, UserMessage userMessage) {
    }

    public void addRelevantDocument(List<TextSegment> segments, UserMessage userMessage) {
    }

    public void addLLMToApplicationMessage(Response<AiMessage> response) {
    }

    public void addApplicationToLLMMessage(ToolExecutionResultMessage toolExecutionResultMessage) {
    }

    public void onCompletion(Object result) {
    }

    public void onFailure(Exception e) {
    }

    public record CreateInfo(String interfaceName, String methodName, Object[] parameters, Optional<Integer> memoryIDParamPosition) {
    }
}

