/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import io.quarkiverse.langchain4j.guardrails.Guardrail;
import java.util.List;

public interface GuardrailResult<GR extends GuardrailResult> {
    public boolean isSuccess();

    default public boolean isRewrittenResult() {
        return false;
    }

    default public GuardrailResult<GR> blockRetry() {
        throw new UnsupportedOperationException();
    }

    default public String successfulResult() {
        throw new UnsupportedOperationException();
    }

    public boolean isFatal();

    public List<? extends Failure> failures();

    default public Throwable getFirstFailureException() {
        if (!this.isSuccess()) {
            for (Failure failure : this.failures()) {
                if (failure.cause() == null) continue;
                return failure.cause();
            }
        }
        return null;
    }

    public GR validatedBy(Class<? extends Guardrail> var1);

    public static interface Failure {
        public Failure withGuardrailClass(Class<? extends Guardrail> var1);

        public String message();

        public Throwable cause();
    }

    public static enum Result {
        SUCCESS,
        SUCCESS_WITH_RESULT,
        FAILURE,
        FATAL;

    }
}

