/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import io.quarkiverse.langchain4j.guardrails.Guardrail;
import io.quarkiverse.langchain4j.guardrails.GuardrailResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public record InputGuardrailResult(GuardrailResult.Result result, List<Failure> failures) implements GuardrailResult<InputGuardrailResult>
{
    private static final InputGuardrailResult SUCCESS = new InputGuardrailResult();

    private InputGuardrailResult() {
        this(GuardrailResult.Result.SUCCESS, Collections.emptyList());
    }

    InputGuardrailResult(List<Failure> failures, boolean fatal) {
        this(fatal ? GuardrailResult.Result.FATAL : GuardrailResult.Result.FAILURE, failures);
    }

    public static InputGuardrailResult success() {
        return SUCCESS;
    }

    public static InputGuardrailResult failure(List<? extends GuardrailResult.Failure> failures) {
        return new InputGuardrailResult(failures, false);
    }

    @Override
    public boolean isSuccess() {
        return this.result == GuardrailResult.Result.SUCCESS;
    }

    @Override
    public boolean isFatal() {
        return this.result == GuardrailResult.Result.FATAL;
    }

    @Override
    public InputGuardrailResult validatedBy(Class<? extends Guardrail> guardrailClass) {
        if (!this.isSuccess()) {
            if (this.failures.size() != 1) {
                throw new IllegalArgumentException();
            }
            this.failures.set(0, (Failure)this.failures.get(0).withGuardrailClass((Class)guardrailClass));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            return "success";
        }
        return this.failures.stream().map(Failure::toString).collect(Collectors.joining(", "));
    }

    record Failure(String message, Throwable cause, Class<? extends Guardrail> guardrailClass) implements GuardrailResult.Failure
    {
        public Failure(String message) {
            this(message, null);
        }

        public Failure(String message, Throwable cause) {
            this(message, cause, null);
        }

        @Override
        public Failure withGuardrailClass(Class<? extends Guardrail> guardrailClass) {
            return new Failure(this.message, this.cause, guardrailClass);
        }

        @Override
        public String toString() {
            return "The guardrail " + this.guardrailClass.getName() + " failed with this message: " + this.message;
        }
    }
}

