/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.retriever.Retriever;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.ToolProvider;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.QuarkusAiServicesFactory;
import io.quarkiverse.langchain4j.RegisterAiService;
import io.quarkiverse.langchain4j.audit.AuditService;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.ToolsRecorder;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkiverse.langchain4j.runtime.aiservice.DeclarativeAiServiceCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class AiServicesRecorder {
    private static final TypeLiteral<Instance<AuditService>> AUDIT_SERVICE_TYPE_LITERAL = new TypeLiteral<Instance<AuditService>>(){};
    private static final TypeLiteral<Instance<RetrievalAugmentor>> RETRIEVAL_AUGMENTOR_TYPE_LITERAL = new TypeLiteral<Instance<RetrievalAugmentor>>(){};
    private static final Map<String, AiServiceClassCreateInfo> metadata = new HashMap<String, AiServiceClassCreateInfo>();

    public void setMetadata(Map<String, AiServiceClassCreateInfo> metadata) {
        AiServicesRecorder.metadata.putAll(metadata);
    }

    public static Map<String, AiServiceClassCreateInfo> getMetadata() {
        return metadata;
    }

    public static void clearMetadata() {
        metadata.clear();
    }

    public static AiServiceMethodCreateInfo getAiServiceMethodCreateInfo(String className, String methodId) {
        AiServiceClassCreateInfo classCreateInfo = metadata.get(className);
        if (classCreateInfo == null) {
            throw new RuntimeException("Quarkus was not able to determine class '" + className + "' as an AiService at build time. Consider annotating the clas with @CreatedAware");
        }
        AiServiceMethodCreateInfo methodCreateInfo = classCreateInfo.methodMap().get(methodId);
        if (methodCreateInfo == null) {
            throw new IllegalStateException("Unable to locate method metadata for descriptor '" + methodId + "'. Please report this issue to the maintainers");
        }
        AiServicesRecorder.populateToolMetadata(methodCreateInfo);
        return methodCreateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateToolMetadata(AiServiceMethodCreateInfo methodCreateInfo) {
        List<String> methodToolClassNames = methodCreateInfo.getToolClassNames();
        if (methodToolClassNames != null && !methodToolClassNames.isEmpty() && methodCreateInfo.getToolSpecifications().isEmpty()) {
            List<ToolSpecification> list = methodCreateInfo.getToolSpecifications();
            synchronized (list) {
                if (methodCreateInfo.getToolSpecifications().isEmpty()) {
                    try {
                        ArrayList<Object> objectWithTools = new ArrayList<Object>(methodToolClassNames.size());
                        for (String toolClass : methodToolClassNames) {
                            Object tool = Arc.container().instance(Thread.currentThread().getContextClassLoader().loadClass(toolClass), new Annotation[0]).get();
                            objectWithTools.add(tool);
                        }
                        ToolsRecorder.populateToolMetadata(objectWithTools, methodCreateInfo.getToolSpecifications(), methodCreateInfo.getToolExecutors());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public <T> Function<SyntheticCreationalContext<T>, T> createDeclarativeAiService(final DeclarativeAiServiceCreateInfo info) {
        return new Function<SyntheticCreationalContext<T>, T>(this){
            final /* synthetic */ AiServicesRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(SyntheticCreationalContext<T> creationalContext) {
                try {
                    Object instance;
                    Supplier supplier;
                    List<String> toolsClasses;
                    Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(info.serviceClassName());
                    QuarkusAiServiceContext aiServiceContext = new QuarkusAiServiceContext(serviceClass);
                    AiServices quarkusAiServices = QuarkusAiServicesFactory.InstanceHolder.INSTANCE.create(aiServiceContext);
                    if (info.languageModelSupplierClassName() != null || info.streamingChatLanguageModelSupplierClassName() != null) {
                        Supplier supplier2;
                        if (info.languageModelSupplierClassName() != null) {
                            supplier2 = AiServicesRecorder.createSupplier(info.languageModelSupplierClassName());
                            quarkusAiServices.chatLanguageModel((ChatLanguageModel)supplier2.get());
                        }
                        if (info.streamingChatLanguageModelSupplierClassName() != null) {
                            supplier2 = AiServicesRecorder.createSupplier(info.streamingChatLanguageModelSupplierClassName());
                            quarkusAiServices.streamingChatLanguageModel((StreamingChatLanguageModel)supplier2.get());
                        }
                    } else if (NamedConfigUtil.isDefault(info.chatModelName())) {
                        quarkusAiServices.chatLanguageModel((ChatLanguageModel)creationalContext.getInjectedReference(ChatLanguageModel.class, new Annotation[0]));
                        if (info.needsStreamingChatModel()) {
                            quarkusAiServices.streamingChatLanguageModel((StreamingChatLanguageModel)creationalContext.getInjectedReference(StreamingChatLanguageModel.class, new Annotation[0]));
                        }
                    } else {
                        quarkusAiServices.chatLanguageModel((ChatLanguageModel)creationalContext.getInjectedReference(ChatLanguageModel.class, new Annotation[]{ModelName.Literal.of(info.chatModelName())}));
                        if (info.needsStreamingChatModel()) {
                            quarkusAiServices.streamingChatLanguageModel((StreamingChatLanguageModel)creationalContext.getInjectedReference(StreamingChatLanguageModel.class, new Annotation[]{ModelName.Literal.of(info.chatModelName())}));
                        }
                    }
                    if ((toolsClasses = info.toolsClassNames()) != null && !toolsClasses.isEmpty()) {
                        ArrayList<Object> tools = new ArrayList<Object>(toolsClasses.size());
                        for (String toolClass : toolsClasses) {
                            Object tool = creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(toolClass), new Annotation[0]);
                            tools.add(tool);
                        }
                        quarkusAiServices.tools(tools);
                    }
                    if (!RegisterAiService.BeanIfExistsToolProviderSupplier.class.getName().equals(info.toolProviderSupplier())) {
                        Class<?> toolProviderClass = Thread.currentThread().getContextClassLoader().loadClass(info.toolProviderSupplier());
                        Supplier toolProvider = (Supplier)creationalContext.getInjectedReference(toolProviderClass, new Annotation[0]);
                        quarkusAiServices.toolProvider((ToolProvider)toolProvider.get());
                    }
                    if (info.chatMemoryProviderSupplierClassName() != null) {
                        if (RegisterAiService.BeanChatMemoryProviderSupplier.class.getName().equals(info.chatMemoryProviderSupplierClassName())) {
                            quarkusAiServices.chatMemoryProvider((ChatMemoryProvider)creationalContext.getInjectedReference(ChatMemoryProvider.class, new Annotation[0]));
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.chatMemoryProviderSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.chatMemoryProvider((ChatMemoryProvider)supplier.get());
                        }
                    }
                    if (info.retrieverClassName() != null) {
                        quarkusAiServices.retriever((Retriever)creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(info.retrieverClassName()), new Annotation[0]));
                    }
                    if (info.retrievalAugmentorSupplierClassName() != null) {
                        if (RegisterAiService.BeanIfExistsRetrievalAugmentorSupplier.class.getName().equals(info.retrievalAugmentorSupplierClassName())) {
                            instance = (Instance)creationalContext.getInjectedReference(RETRIEVAL_AUGMENTOR_TYPE_LITERAL, new Annotation[0]);
                            if (instance.isResolvable()) {
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)instance.get());
                            }
                        } else {
                            try {
                                instance = (Supplier)creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(info.retrievalAugmentorSupplierClassName()), new Annotation[0]);
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)instance.get());
                            }
                            catch (IllegalArgumentException e) {
                                Supplier supplier3 = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.retrievalAugmentorSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)supplier3.get());
                            }
                        }
                    }
                    if (info.auditServiceClassSupplierName() != null) {
                        if (RegisterAiService.BeanIfExistsAuditServiceSupplier.class.getName().equals(info.auditServiceClassSupplierName())) {
                            instance = (Instance)creationalContext.getInjectedReference(AUDIT_SERVICE_TYPE_LITERAL, new Annotation[0]);
                            if (instance.isResolvable()) {
                                quarkusAiServices.auditService((AuditService)instance.get());
                            }
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.auditServiceClassSupplierName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.auditService((AuditService)supplier.get());
                        }
                    }
                    if (info.moderationModelSupplierClassName() != null && info.needsModerationModel()) {
                        if (RegisterAiService.BeanIfExistsModerationModelSupplier.class.getName().equals(info.moderationModelSupplierClassName())) {
                            if (NamedConfigUtil.isDefault(info.moderationModelName())) {
                                quarkusAiServices.moderationModel((ModerationModel)creationalContext.getInjectedReference(ModerationModel.class, new Annotation[0]));
                            } else {
                                quarkusAiServices.moderationModel((ModerationModel)creationalContext.getInjectedReference(ModerationModel.class, new Annotation[]{ModelName.Literal.of(info.moderationModelName())}));
                            }
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.moderationModelSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.moderationModel((ModerationModel)supplier.get());
                        }
                    }
                    if (info.imageModelSupplierClassName() != null && info.needsImageModel()) {
                        if (RegisterAiService.BeanIfExistsImageModelSupplier.class.getName().equals(info.imageModelSupplierClassName())) {
                            if (NamedConfigUtil.isDefault(info.chatModelName())) {
                                quarkusAiServices.imageModel((ImageModel)creationalContext.getInjectedReference(ImageModel.class, new Annotation[0]));
                            } else {
                                quarkusAiServices.imageModel((ImageModel)creationalContext.getInjectedReference(ImageModel.class, new Annotation[]{ModelName.Literal.of(info.chatModelName())}));
                            }
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.imageModelSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.imageModel((ImageModel)supplier.get());
                        }
                    }
                    if (info.chatMemorySeederClassName() != null) {
                        quarkusAiServices.chatMemorySeeder((ChatMemorySeeder)Thread.currentThread().getContextClassLoader().loadClass(info.chatMemorySeederClassName()).getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    return (Object)aiServiceContext;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static <T> Supplier<T> createSupplier(String className) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return (Supplier)Thread.currentThread().getContextClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

