/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class InProcessEmbeddingRecorder {
    public Supplier<?> instantiate(final String className) {
        return new Supplier<Object>(){
            final /* synthetic */ InProcessEmbeddingRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object get() {
                try {
                    ScheduledExecutorService executor = Infrastructure.getDefaultWorkerPool();
                    Class<?> loaded = InProcessEmbeddingRecorder.class.getClassLoader().loadClass(className);
                    try {
                        return loaded.getDeclaredConstructor(Executor.class).newInstance(executor);
                    }
                    catch (NoSuchMethodException e) {
                        Logger.getLogger(InProcessEmbeddingRecorder.class).warn("Cannot locate in-process embedding model's %s constructor that takes a java.util.concurrent.Executor, using the default constructor as fallback", (Object)className, (Throwable)e);
                        return loaded.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(InProcessEmbeddingRecorder.class).errorf("Failed to instantiate in-process embedding model %s", (Object)className, (Object)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

