/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.ToolExecutor;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusAiServiceStreamingResponseHandler
implements StreamingResponseHandler<AiMessage> {
    private final Logger log = Logger.getLogger(QuarkusAiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> tokenHandler;
    private final Consumer<Response<AiMessage>> completionHandler;
    private final Consumer<Throwable> errorHandler;
    private final List<ChatMessage> temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final Context executionContext;
    private final boolean mustSwitchToWorkerThread;

    QuarkusAiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> tokenHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, boolean mustSwitchToWorkerThread, Context cxtx) {
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.tokenHandler = (Consumer)ValidationUtils.ensureNotNull(tokenHandler, (String)"tokenHandler");
        this.completionHandler = completionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = new ArrayList<ChatMessage>(temporaryMemory);
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
        this.toolExecutors = Utils.copyIfNotNull(toolExecutors);
        this.mustSwitchToWorkerThread = mustSwitchToWorkerThread;
        this.executionContext = cxtx;
    }

    public void onNext(String token) {
        this.tokenHandler.accept(token);
    }

    private void executeTools(final Runnable runnable) {
        if (this.mustSwitchToWorkerThread && Context.isOnEventLoopThread()) {
            if (this.executionContext != null) {
                this.executionContext.executeBlocking((Callable)new Callable<Object>(){
                    final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Object call() {
                        runnable.run();
                        return null;
                    }
                });
            } else {
                Infrastructure.getDefaultWorkerPool().execute(runnable);
            }
        } else {
            runnable.run();
        }
    }

    public void onComplete(final Response<AiMessage> response) {
        final AiMessage aiMessage = (AiMessage)response.content();
        this.addToMemory((ChatMessage)aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            this.executeTools(new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                        String toolName = toolExecutionRequest.name();
                        ToolExecutor toolExecutor = this.this$0.toolExecutors.get(toolName);
                        String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, this.this$0.memoryId);
                        ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                        this.this$0.addToMemory((ChatMessage)toolExecutionResultMessage);
                    }
                    this.this$0.context.streamingChatModel.generate(this.this$0.messagesToSend(this.this$0.memoryId), this.this$0.toolSpecifications, (StreamingResponseHandler)new QuarkusAiServiceStreamingResponseHandler(this.this$0.context, this.this$0.memoryId, this.this$0.tokenHandler, this.this$0.completionHandler, this.this$0.errorHandler, this.this$0.temporaryMemory, TokenUsage.sum((TokenUsage)this.this$0.tokenUsage, (TokenUsage)response.tokenUsage()), this.this$0.toolSpecifications, this.this$0.toolExecutors, this.this$0.mustSwitchToWorkerThread, this.this$0.executionContext));
                }
            });
        } else if (this.completionHandler != null) {
            this.completionHandler.accept((Response<AiMessage>)Response.from((Object)aiMessage, (TokenUsage)TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)response.tokenUsage()), (FinishReason)response.finishReason()));
        }
    }

    private void addToMemory(ChatMessage chatMessage) {
        if (this.context.hasChatMemory()) {
            this.context.chatMemory(this.memoryId).add(chatMessage);
        } else {
            this.temporaryMemory.add(chatMessage);
        }
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.context.hasChatMemory() ? this.context.chatMemory(memoryId).messages() : this.temporaryMemory;
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                this.log.error((Object)"While handling the following error...", error);
                this.log.error((Object)"...the following error happened", (Throwable)e);
            }
        } else {
            this.log.warn((Object)"Ignored error", error);
        }
    }
}

