/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.tool.ToolExecutor;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceStreamingResponseHandler;
import io.vertx.core.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class QuarkusAiServiceTokenStream
implements TokenStream {
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final List<Content> retrievedContents;
    private final AiServiceContext context;
    private final Object memoryId;
    private final Context cxtx;
    private final boolean mustSwitchToWorkerThread;
    private Consumer<String> tokenHandler;
    private Consumer<List<Content>> contentsHandler;
    private Consumer<Throwable> errorHandler;
    private Consumer<Response<AiMessage>> completionHandler;
    private int onNextInvoked;
    private int onCompleteInvoked;
    private int onRetrievedInvoked;
    private int onErrorInvoked;
    private int ignoreErrorsInvoked;

    public QuarkusAiServiceTokenStream(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, List<Content> retrievedContents, AiServiceContext context, Object memoryId, Context ctxt, boolean mustSwitchToWorkerThread) {
        this.messages = (List)ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
        this.toolExecutors = Utils.copyIfNotNull(toolExecutors);
        this.retrievedContents = retrievedContents;
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        ValidationUtils.ensureNotNull((Object)context.streamingChatModel, (String)"streamingChatModel");
        this.cxtx = ctxt;
        this.mustSwitchToWorkerThread = mustSwitchToWorkerThread;
    }

    public TokenStream onNext(Consumer<String> tokenHandler) {
        this.tokenHandler = tokenHandler;
        ++this.onNextInvoked;
        return this;
    }

    public TokenStream onRetrieved(Consumer<List<Content>> contentsHandler) {
        this.contentsHandler = contentsHandler;
        ++this.onRetrievedInvoked;
        return this;
    }

    public TokenStream onComplete(Consumer<Response<AiMessage>> completionHandler) {
        this.completionHandler = completionHandler;
        ++this.onCompleteInvoked;
        return this;
    }

    public TokenStream onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        ++this.onErrorInvoked;
        return this;
    }

    public TokenStream ignoreErrors() {
        this.errorHandler = null;
        ++this.ignoreErrorsInvoked;
        return this;
    }

    public void start() {
        this.validateConfiguration();
        QuarkusAiServiceStreamingResponseHandler handler = new QuarkusAiServiceStreamingResponseHandler(this.context, this.memoryId, this.tokenHandler, this.completionHandler, this.errorHandler, this.initTemporaryMemory(this.context, this.messages), new TokenUsage(), this.toolSpecifications, this.toolExecutors, this.mustSwitchToWorkerThread, this.cxtx);
        if (this.contentsHandler != null && this.retrievedContents != null) {
            this.contentsHandler.accept(this.retrievedContents);
        }
        if (Utils.isNullOrEmpty(this.toolSpecifications)) {
            this.context.streamingChatModel.generate(this.messages, (StreamingResponseHandler)handler);
        } else {
            this.context.streamingChatModel.generate(this.messages, this.toolSpecifications, (StreamingResponseHandler)handler);
        }
    }

    private void validateConfiguration() {
        if (this.onNextInvoked != 1) {
            throw new IllegalConfigurationException("onNext must be invoked exactly 1 time");
        }
        if (this.onCompleteInvoked > 1) {
            throw new IllegalConfigurationException("onComplete must be invoked at most 1 time");
        }
        if (this.onRetrievedInvoked > 1) {
            throw new IllegalConfigurationException("onRetrieved must be invoked at most 1 time");
        }
        if (this.onErrorInvoked + this.ignoreErrorsInvoked != 1) {
            throw new IllegalConfigurationException("One of onError or ignoreErrors must be invoked exactly 1 time");
        }
    }

    private List<ChatMessage> initTemporaryMemory(AiServiceContext context, List<ChatMessage> messagesToSend) {
        if (context.hasChatMemory()) {
            return Collections.emptyList();
        }
        return new ArrayList<ChatMessage>(messagesToSend);
    }
}

