/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observers.SerializedObserver;
import rx.subjects.PublishSubject;
import rx.subscriptions.Subscriptions;

@Experimental
public class SchedulerWhen
extends Scheduler
implements Subscription {
    private final Scheduler actualScheduler;
    private final Observer<Observable<Completable>> workerObserver;
    private final Subscription subscription;
    static final Subscription SUBSCRIBED = new Subscription(){

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return false;
        }
    };
    static final Subscription UNSUBSCRIBED = Subscriptions.unsubscribed();

    public SchedulerWhen(Func1<Observable<Observable<Completable>>, Completable> combine, Scheduler actualScheduler) {
        this.actualScheduler = actualScheduler;
        PublishSubject workerSubject = PublishSubject.create();
        this.workerObserver = new SerializedObserver<Observable<Completable>>(workerSubject);
        this.subscription = combine.call(workerSubject.onBackpressureBuffer()).subscribe();
    }

    @Override
    public void unsubscribe() {
        this.subscription.unsubscribe();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.subscription.isUnsubscribed();
    }

    @Override
    public Scheduler.Worker createWorker() {
        final Scheduler.Worker actualWorker = this.actualScheduler.createWorker();
        BufferUntilSubscriber<ScheduledAction> actionSubject = BufferUntilSubscriber.create();
        final SerializedObserver actionObserver = new SerializedObserver(actionSubject);
        Observable<Completable> actions = actionSubject.map(new Func1<ScheduledAction, Completable>(){

            @Override
            public Completable call(final ScheduledAction action) {
                return Completable.create(new Completable.OnSubscribe(){

                    @Override
                    public void call(CompletableSubscriber actionCompletable) {
                        actionCompletable.onSubscribe(action);
                        action.call(actualWorker, actionCompletable);
                    }
                });
            }
        });
        Scheduler.Worker worker = new Scheduler.Worker(){
            private final AtomicBoolean unsubscribed = new AtomicBoolean();

            @Override
            public void unsubscribe() {
                if (this.unsubscribed.compareAndSet(false, true)) {
                    actualWorker.unsubscribe();
                    actionObserver.onCompleted();
                }
            }

            @Override
            public boolean isUnsubscribed() {
                return this.unsubscribed.get();
            }

            @Override
            public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
                DelayedAction delayedAction = new DelayedAction(action, delayTime, unit);
                actionObserver.onNext(delayedAction);
                return delayedAction;
            }

            @Override
            public Subscription schedule(Action0 action) {
                ImmediateAction immediateAction = new ImmediateAction(action);
                actionObserver.onNext(immediateAction);
                return immediateAction;
            }
        };
        this.workerObserver.onNext(actions);
        return worker;
    }

    static class OnCompletedAction
    implements Action0 {
        private CompletableSubscriber actionCompletable;
        private Action0 action;

        public OnCompletedAction(Action0 action, CompletableSubscriber actionCompletable) {
            this.action = action;
            this.actionCompletable = actionCompletable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call() {
            try {
                this.action.call();
            }
            finally {
                this.actionCompletable.onCompleted();
            }
        }
    }

    static class DelayedAction
    extends ScheduledAction {
        private final Action0 action;
        private final long delayTime;
        private final TimeUnit unit;

        public DelayedAction(Action0 action, long delayTime, TimeUnit unit) {
            this.action = action;
            this.delayTime = delayTime;
            this.unit = unit;
        }

        @Override
        protected Subscription callActual(Scheduler.Worker actualWorker, CompletableSubscriber actionCompletable) {
            return actualWorker.schedule(new OnCompletedAction(this.action, actionCompletable), this.delayTime, this.unit);
        }
    }

    static class ImmediateAction
    extends ScheduledAction {
        private final Action0 action;

        public ImmediateAction(Action0 action) {
            this.action = action;
        }

        @Override
        protected Subscription callActual(Scheduler.Worker actualWorker, CompletableSubscriber actionCompletable) {
            return actualWorker.schedule(new OnCompletedAction(this.action, actionCompletable));
        }
    }

    static abstract class ScheduledAction
    extends AtomicReference<Subscription>
    implements Subscription {
        public ScheduledAction() {
            super(SUBSCRIBED);
        }

        private void call(Scheduler.Worker actualWorker, CompletableSubscriber actionCompletable) {
            Subscription oldState = (Subscription)this.get();
            if (oldState == UNSUBSCRIBED) {
                return;
            }
            if (oldState != SUBSCRIBED) {
                return;
            }
            Subscription newState = this.callActual(actualWorker, actionCompletable);
            if (!this.compareAndSet(SUBSCRIBED, newState)) {
                newState.unsubscribe();
            }
        }

        protected abstract Subscription callActual(Scheduler.Worker var1, CompletableSubscriber var2);

        @Override
        public boolean isUnsubscribed() {
            return ((Subscription)this.get()).isUnsubscribed();
        }

        @Override
        public void unsubscribe() {
            Subscription oldState;
            Subscription newState = UNSUBSCRIBED;
            do {
                if ((oldState = (Subscription)this.get()) != UNSUBSCRIBED) continue;
                return;
            } while (!this.compareAndSet(oldState, newState));
            if (oldState != SUBSCRIBED) {
                oldState.unsubscribe();
            }
        }
    }
}

