/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.channel.Channel;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.IncompatibleVersionException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    private static final String CURRENT = "1.5.0";
    private static final String VERSION_0_7_1 = "0.7.1";
    private static final String VERSION_1_5_0 = "1.5.0";
    private static final int MAX_VERSION_DOT = 3;
    public static final Map<String, String> VERSION_MAP = new ConcurrentHashMap<String, String>();

    private Version() {
    }

    public static String getCurrent() {
        return "1.5.0";
    }

    public static void putChannelVersion(Channel c, String v) {
        VERSION_MAP.put(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()), v);
    }

    public static String getChannelVersion(Channel c) {
        return VERSION_MAP.get(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()));
    }

    public static void checkVersion(String version) throws IncompatibleVersionException {
        long current = Version.convertVersion("1.5.0");
        long clientVersion = Version.convertVersion(version);
        long divideVersion = Version.convertVersion(VERSION_0_7_1);
        if (current > divideVersion && clientVersion < divideVersion || current < divideVersion && clientVersion > divideVersion) {
            throw new IncompatibleVersionException("incompatible client version:" + version);
        }
    }

    public static boolean isAboveOrEqualVersion150(String version) {
        boolean isAboveOrEqualVersion150 = false;
        try {
            long clientVersion = Version.convertVersion(version);
            long divideVersion = Version.convertVersion("1.5.0");
            isAboveOrEqualVersion150 = clientVersion >= divideVersion;
        }
        catch (Exception e) {
            LOGGER.error("convert version error, clientVersion:{}", (Object)version, (Object)e);
        }
        return isAboveOrEqualVersion150;
    }

    private static long convertVersion(String version) throws IncompatibleVersionException {
        String[] parts = StringUtils.split((String)version, (char)'.');
        long result = 0L;
        int i = 1;
        int size = parts.length;
        if (size > 4) {
            throw new IncompatibleVersionException("incompatible version format:" + version);
        }
        size = 4;
        for (String part : parts) {
            if (StringUtils.isNumeric((String)part)) {
                result += Version.calculatePartValue(part, size, i);
            } else {
                String[] subParts = StringUtils.split((String)part, (char)'-');
                if (StringUtils.isNumeric((String)subParts[0])) {
                    result += Version.calculatePartValue(subParts[0], size, i);
                }
            }
            ++i;
        }
        return result;
    }

    private static long calculatePartValue(String partNumeric, int size, int index) {
        return Long.parseLong(partNumeric) * Double.valueOf(Math.pow(100.0, size - index)).longValue();
    }
}

