/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.stork.api.config.ConfigWithType;

public class ServiceDefinition {
    private final ConfigWithType loadBalancer;
    private final ConfigWithType serviceDiscovery;
    private final ConfigWithType serviceRegistrar;

    private ServiceDefinition(ConfigWithType sd, ConfigWithType lb, ConfigWithType sr) {
        this.serviceDiscovery = (ConfigWithType)ParameterValidation.nonNull((Object)sd, (String)"service discovery config");
        this.loadBalancer = lb;
        this.serviceRegistrar = sr;
    }

    public static ServiceDefinition of(ConfigWithType sd) {
        return ServiceDefinition.of(sd, null);
    }

    public static ServiceDefinition of(ConfigWithType sd, ConfigWithType lb, ConfigWithType sr) {
        return new ServiceDefinition(sd, lb, sr);
    }

    public static ServiceDefinition of(ConfigWithType sd, ConfigWithType lb) {
        return new ServiceDefinition(sd, lb, null);
    }

    public ConfigWithType getLoadBalancer() {
        return this.loadBalancer;
    }

    public ConfigWithType getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ConfigWithType getServiceRegistrar() {
        return this.serviceRegistrar;
    }
}

