/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.lookup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.AbstractMemberLookup;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class AddressServerMemberLookup
extends AbstractMemberLookup {
    private final GenericType<String> genericType = new GenericType<String>(){};
    public String domainName;
    public String addressPort;
    public String addressUrl;
    public String envIdUrl;
    public String addressServerUrl;
    private volatile boolean isAddressServerHealth = true;
    private int addressServerFailCount = 0;
    private int maxFailCount = 12;
    private final NacosRestTemplate restTemplate = HttpClientBeanHolder.getNacosRestTemplate((Logger)Loggers.CORE);
    private volatile boolean shutdown = false;
    private static final String HEALTH_CHECK_FAIL_COUNT_PROPERTY = "maxHealthCheckFailCount";
    private static final String DEFAULT_HEALTH_CHECK_FAIL_COUNT = "12";
    private static final String DEFAULT_SERVER_DOMAIN = "jmenv.tbsite.net";
    private static final String DEFAULT_SERVER_POINT = "8080";
    private static final int DEFAULT_SERVER_RETRY_TIME = 5;
    private static final long DEFAULT_SYNC_TASK_DELAY_MS = 5000L;
    private static final String ADDRESS_SERVER_DOMAIN_ENV = "address_server_domain";
    private static final String ADDRESS_SERVER_DOMAIN_PROPERTY = "address.server.domain";
    private static final String ADDRESS_SERVER_PORT_ENV = "address_server_port";
    private static final String ADDRESS_SERVER_PORT_PROPERTY = "address.server.port";
    private static final String ADDRESS_SERVER_URL_ENV = "address_server_url";
    private static final String ADDRESS_SERVER_URL_PROPERTY = "address.server.url";
    private static final String ADDRESS_SERVER_RETRY_PROPERTY = "nacos.core.address-server.retry";

    @Override
    public void doStart() throws NacosException {
        this.maxFailCount = Integer.parseInt(EnvUtil.getProperty((String)HEALTH_CHECK_FAIL_COUNT_PROPERTY, (String)DEFAULT_HEALTH_CHECK_FAIL_COUNT));
        this.initAddressSys();
        this.run();
    }

    @Override
    public boolean useAddressServer() {
        return true;
    }

    private void initAddressSys() {
        String envDomainName = System.getenv(ADDRESS_SERVER_DOMAIN_ENV);
        this.domainName = StringUtils.isBlank((CharSequence)envDomainName) ? EnvUtil.getProperty((String)ADDRESS_SERVER_DOMAIN_PROPERTY, (String)DEFAULT_SERVER_DOMAIN) : envDomainName;
        String envAddressPort = System.getenv(ADDRESS_SERVER_PORT_ENV);
        this.addressPort = StringUtils.isBlank((CharSequence)envAddressPort) ? EnvUtil.getProperty((String)ADDRESS_SERVER_PORT_PROPERTY, (String)DEFAULT_SERVER_POINT) : envAddressPort;
        String envAddressUrl = System.getenv(ADDRESS_SERVER_URL_ENV);
        this.addressUrl = StringUtils.isBlank((CharSequence)envAddressUrl) ? EnvUtil.getProperty((String)ADDRESS_SERVER_URL_PROPERTY, (String)(EnvUtil.getContextPath() + "/serverlist")) : envAddressUrl;
        this.addressServerUrl = "http://" + this.domainName + ":" + this.addressPort + this.addressUrl;
        this.envIdUrl = "http://" + this.domainName + ":" + this.addressPort + "/env";
        Loggers.CORE.info("ServerListService address-server port:" + this.addressPort);
        Loggers.CORE.info("ADDRESS_SERVER_URL:" + this.addressServerUrl);
    }

    private void run() throws NacosException {
        boolean success = false;
        Throwable ex = null;
        int maxRetry = (Integer)EnvUtil.getProperty((String)ADDRESS_SERVER_RETRY_PROPERTY, Integer.class, (Object)5);
        for (int i = 0; i < maxRetry; ++i) {
            try {
                this.syncFromAddressUrl();
                success = true;
                break;
            }
            catch (Throwable e) {
                ex = e;
                Loggers.CLUSTER.error("[serverlist] exception, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
                continue;
            }
        }
        if (!success) {
            throw new NacosException(500, ex);
        }
        GlobalExecutor.scheduleByCommon(new AddressServerSyncTask(), 5000L);
    }

    @Override
    protected void doDestroy() throws NacosException {
        this.shutdown = true;
    }

    @Override
    public Map<String, Object> info() {
        HashMap<String, Object> info = new HashMap<String, Object>(4);
        info.put("addressServerHealth", this.isAddressServerHealth);
        info.put("addressServerUrl", this.addressServerUrl);
        info.put("envIdUrl", this.envIdUrl);
        info.put("addressServerFailCount", this.addressServerFailCount);
        return info;
    }

    private void syncFromAddressUrl() throws Exception {
        HttpRestResult result = this.restTemplate.get(this.addressServerUrl, Header.EMPTY, Query.EMPTY, this.genericType.getType());
        if (result.ok()) {
            this.isAddressServerHealth = true;
            StringReader reader = new StringReader((String)result.getData());
            try {
                this.afterLookup(MemberUtil.readServerConf(EnvUtil.analyzeClusterConf((Reader)reader)));
            }
            catch (Throwable e) {
                Loggers.CLUSTER.error("[serverlist] exception for analyzeClusterConf, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
            }
            this.addressServerFailCount = 0;
        } else {
            ++this.addressServerFailCount;
            if (this.addressServerFailCount >= this.maxFailCount) {
                this.isAddressServerHealth = false;
            }
            Loggers.CLUSTER.error("[serverlist] failed to get serverlist, error code {}", (Object)result.getCode());
        }
    }

    class AddressServerSyncTask
    implements Runnable {
        AddressServerSyncTask() {
        }

        @Override
        public void run() {
            if (AddressServerMemberLookup.this.shutdown) {
                return;
            }
            try {
                AddressServerMemberLookup.this.syncFromAddressUrl();
            }
            catch (Throwable ex) {
                AddressServerMemberLookup.this.addressServerFailCount++;
                if (AddressServerMemberLookup.this.addressServerFailCount >= AddressServerMemberLookup.this.maxFailCount) {
                    AddressServerMemberLookup.this.isAddressServerHealth = false;
                }
                Loggers.CLUSTER.error("[serverlist] exception, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
            }
            finally {
                GlobalExecutor.scheduleByCommon(this, 5000L);
            }
        }
    }
}

