/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/core/cluster"})
public class NacosClusterController {
    private final ServerMemberManager memberManager;

    public NacosClusterController(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @GetMapping(value={"/self"})
    public RestResult<Member> self() {
        return RestResultUtils.success((Object)this.memberManager.getSelf());
    }

    @GetMapping(value={"/nodes"})
    public RestResult<Collection<Member>> listNodes(@RequestParam(value="keyword", required=false) String ipKeyWord) {
        Collection<Member> members = this.memberManager.allMembers();
        ArrayList result = new ArrayList();
        members.stream().sorted().forEach(member -> {
            if (StringUtils.isBlank((CharSequence)ipKeyWord)) {
                result.add(member);
                return;
            }
            String address = member.getAddress();
            if (StringUtils.equals((String)address, (String)ipKeyWord) || StringUtils.startsWith((CharSequence)address, (CharSequence)ipKeyWord)) {
                result.add(member);
            }
        });
        return RestResultUtils.success(result);
    }

    @GetMapping(value={"/simple/nodes"})
    public RestResult<Collection<String>> listSimpleNodes() {
        return RestResultUtils.success(this.memberManager.getMemberAddressInfos());
    }

    @GetMapping(value={"/health"})
    public RestResult<String> getHealth() {
        return RestResultUtils.success((Object)this.memberManager.getSelf().getState().name());
    }

    @PostMapping(value={"/report"})
    public RestResult<String> report(@RequestBody Member node) {
        if (!node.check()) {
            return RestResultUtils.failedWithMsg((int)400, (String)"Node information is illegal");
        }
        LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"node state report, receive info : {}", (Object[])new Object[]{node});
        node.setState(NodeState.UP);
        node.setFailAccessCnt(0);
        boolean result = this.memberManager.update(node);
        return RestResultUtils.success((Object)Boolean.toString(result));
    }

    @PostMapping(value={"/switch/lookup"})
    public RestResult<String> switchLookup(@RequestParam(name="type") String type) {
        try {
            this.memberManager.switchLookup(type);
            return RestResultUtils.success();
        }
        catch (Throwable ex) {
            return RestResultUtils.failed((String)ex.getMessage());
        }
    }

    @PostMapping(value={"/server/leave"})
    public RestResult<String> leave(@RequestBody Collection<String> params, @RequestParam(defaultValue="true") Boolean notifyOtherMembers) throws Exception {
        Collection<Member> memberList = MemberUtil.multiParse(params);
        this.memberManager.memberLeave(memberList);
        if (Boolean.FALSE.equals(notifyOtherMembers)) {
            return RestResultUtils.success((Object)"ok");
        }
        NacosAsyncRestTemplate nacosAsyncRestTemplate = HttpClientBeanHolder.getNacosAsyncRestTemplate((Logger)Loggers.CLUSTER);
        GenericType<RestResult<String>> genericType = new GenericType<RestResult<String>>(){};
        List<Member> notifyList = this.memberManager.allMembersWithoutSelf();
        notifyList.removeAll(memberList);
        final CountDownLatch latch = new CountDownLatch(notifyList.size());
        for (final Member member : notifyList) {
            String url = HttpUtils.buildUrl((boolean)false, (String)member.getAddress(), (String[])new String[]{EnvUtil.getContextPath(), "/v1/core", "/cluster/server/leave?notifyOtherMembers=false"});
            nacosAsyncRestTemplate.post(url, Header.EMPTY, Query.EMPTY, params, genericType.getType(), (Callback)new Callback<String>(){

                public void onReceive(RestResult<String> result) {
                    try {
                        if (result.ok()) {
                            LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"The node : [{}] success to process the request", (Object[])new Object[]{member});
                            MemberUtil.onSuccess(NacosClusterController.this.memberManager, member);
                        } else {
                            Loggers.CLUSTER.warn("The node : [{}] failed to process the request, response is : {}", (Object)member, result);
                            MemberUtil.onFail(NacosClusterController.this.memberManager, member);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public void onError(Throwable throwable) {
                    try {
                        Loggers.CLUSTER.error("Failed to communicate with the node : {}", (Object)member);
                        MemberUtil.onFail(NacosClusterController.this.memberManager, member);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public void onCancel() {
                }
            });
        }
        try {
            latch.await(10000L, TimeUnit.MILLISECONDS);
            return RestResultUtils.success((Object)"ok");
        }
        catch (Throwable ex) {
            return RestResultUtils.failed((String)ex.getMessage());
        }
    }
}

