/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.ReuseHttpRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ReuseHttpServletRequest
extends HttpServletRequestWrapper
implements ReuseHttpRequest {
    private final HttpServletRequest target;
    private byte[] body;
    private Map<String, String[]> stringMap;

    public ReuseHttpServletRequest(HttpServletRequest request) throws IOException {
        super(request);
        this.target = request;
        this.body = this.toBytes((InputStream)request.getInputStream());
        this.stringMap = this.toDuplication(request);
    }

    @Override
    public Object getBody() throws Exception {
        if (StringUtils.containsIgnoreCase((CharSequence)this.target.getContentType(), (CharSequence)"multipart/form-data;charset=UTF-8")) {
            return this.target.getParts();
        }
        String s = ByteUtils.toString((byte[])this.body);
        if (StringUtils.isBlank((CharSequence)s)) {
            return HttpUtils.encodingParams((Map)HttpUtils.translateParameterMap(this.stringMap), (String)StandardCharsets.UTF_8.name());
        }
        return s;
    }

    private byte[] toBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, n);
        }
        return bos.toByteArray();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public Map<String, String[]> getParameterMap() {
        return this.stringMap;
    }

    public String getParameter(String name) {
        String[] values = this.stringMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.stringMap.get(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

