/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.batch.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.grpc.AsyncGrpcClient;
import io.weaviate.client.base.util.Assert;
import io.weaviate.client.base.util.Futures;
import io.weaviate.client.base.util.GrpcVersionSupport;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBatch;
import io.weaviate.client.v1.async.data.Data;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.batch.grpc.BatchObjectConverter;
import io.weaviate.client.v1.batch.model.ObjectGetResponse;
import io.weaviate.client.v1.batch.model.ObjectsBatchRequestBody;
import io.weaviate.client.v1.batch.model.ObjectsGetResponseAO2Result;
import io.weaviate.client.v1.batch.util.ObjectsPath;
import io.weaviate.client.v1.data.model.WeaviateObject;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class ObjectsBatcher
extends AsyncBaseClient<ObjectGetResponse[]>
implements AsyncClientResult<ObjectGetResponse[]> {
    private final Data data;
    private final ObjectsPath objectsPath;
    private final AccessTokenProvider tokenProvider;
    private final GrpcVersionSupport grpcVersionSupport;
    private final BatchRetriesConfig batchRetriesConfig;
    private final AutoBatchConfig autoBatchConfig;
    private final Config config;
    private final boolean autoRunEnabled;
    private final Executor executor;
    private final List<CompletableFuture<Result<ObjectGetResponse[]>>> futures;
    private final List<WeaviateObject> objects;
    private String consistencyLevel;

    private ObjectsBatcher(CloseableHttpAsyncClient client, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, GrpcVersionSupport grpcVersionSupport, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig, Executor executor) {
        super(client, config, tokenProvider);
        this.config = config;
        this.tokenProvider = tokenProvider;
        this.data = data;
        this.objectsPath = objectsPath;
        this.grpcVersionSupport = grpcVersionSupport;
        this.batchRetriesConfig = batchRetriesConfig;
        this.objects = Collections.synchronizedList(new ArrayList());
        this.futures = Collections.synchronizedList(new ArrayList());
        this.executor = executor;
        if (autoBatchConfig != null) {
            this.autoRunEnabled = true;
            this.autoBatchConfig = autoBatchConfig;
        } else {
            this.autoRunEnabled = false;
            this.autoBatchConfig = null;
        }
    }

    public static ObjectsBatcher create(CloseableHttpAsyncClient client, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, GrpcVersionSupport grpcVersionSupport, BatchRetriesConfig batchRetriesConfig, Executor executor) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        return new ObjectsBatcher(client, config, data, objectsPath, tokenProvider, grpcVersionSupport, batchRetriesConfig, null, executor);
    }

    public static ObjectsBatcher createAuto(CloseableHttpAsyncClient client, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, GrpcVersionSupport grpcVersionSupport, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig, Executor executor) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        Assert.requiredNotNull(autoBatchConfig, "autoBatchConfig");
        return new ObjectsBatcher(client, config, data, objectsPath, tokenProvider, grpcVersionSupport, batchRetriesConfig, autoBatchConfig, executor);
    }

    public ObjectsBatcher withObject(WeaviateObject object) {
        return this.withObjects(object);
    }

    public ObjectsBatcher withObjects(WeaviateObject ... objects) {
        this.addMissingIds(objects);
        this.objects.addAll(Arrays.asList(objects));
        this.autoRun();
        return this;
    }

    public ObjectsBatcher withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    private void addMissingIds(WeaviateObject[] objects) {
        Arrays.stream(objects).filter(o -> o.getId() == null).forEach(o -> o.setId(UUID.randomUUID().toString()));
    }

    private List<WeaviateObject> extractBatch(int batchSize) {
        ArrayList<WeaviateObject> batch = new ArrayList<WeaviateObject>(batchSize);
        List<WeaviateObject> sublist = this.objects.subList(0, batchSize);
        batch.addAll(sublist);
        sublist.clear();
        return batch;
    }

    private void autoRun() {
        if (!this.autoRunEnabled) {
            return;
        }
        while (this.objects.size() >= this.autoBatchConfig.batchSize) {
            List<WeaviateObject> batch = this.extractBatch(this.autoBatchConfig.batchSize);
            this.runBatch(batch);
        }
    }

    @Override
    public Future<Result<ObjectGetResponse[]>> run(FutureCallback<Result<ObjectGetResponse[]>> callback) {
        CompletionStage<Result<Object>> future = this.runAll();
        if (callback != null) {
            future = future.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    callback.failed((Exception)throwable);
                } else {
                    callback.completed(result);
                }
            });
        }
        return future;
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> runAll() {
        if (!this.autoRunEnabled) {
            if (this.objects.isEmpty()) {
                return CompletableFuture.completedFuture(new Result<ObjectGetResponse[]>(0, new ObjectGetResponse[0], null));
            }
            List<WeaviateObject> batch = this.extractBatch(this.objects.size());
            return this.runBatchRecursively(batch, 0, 0, null);
        }
        if (!this.objects.isEmpty()) {
            List<WeaviateObject> batch = this.extractBatch(this.objects.size());
            this.runBatch(batch);
        }
        if (this.futures.isEmpty()) {
            return CompletableFuture.completedFuture(new Result<ObjectGetResponse[]>(0, new ObjectGetResponse[0], null));
        }
        CompletableFuture[] futuresAsArray = this.futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futuresAsArray).thenApply(v -> {
            ArrayList allResponses = new ArrayList();
            ArrayList<WeaviateErrorMessage> allMessages = new ArrayList<WeaviateErrorMessage>();
            int[] lastErrStatusCode = new int[]{200};
            this.futures.stream().map(resultCompletableFuture -> {
                try {
                    return (Result)resultCompletableFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new CompletionException(e);
                }
            }).forEach(result -> {
                Optional.ofNullable(result).map(Result::getResult).map(Arrays::asList).ifPresent(allResponses::addAll);
                Optional.ofNullable(result).filter(Result::hasErrors).map(Result::getError).map(WeaviateError::getMessages).ifPresent(allMessages::addAll);
                Optional.ofNullable(result).filter(Result::hasErrors).map(Result::getError).map(WeaviateError::getStatusCode).ifPresent(sc -> {
                    lastErrStatusCode[0] = sc;
                });
            });
            WeaviateErrorResponse errorResponse = allMessages.isEmpty() ? null : WeaviateErrorResponse.builder().error(allMessages).code(lastErrStatusCode[0]).build();
            return new Result<ObjectGetResponse[]>(lastErrStatusCode[0], allResponses.toArray(new ObjectGetResponse[0]), errorResponse);
        });
    }

    private void runBatch(List<WeaviateObject> batch) {
        CompletionStage<Result<Object>> future = this.runBatchRecursively(batch, 0, 0, null);
        if (this.autoBatchConfig.callback != null) {
            future = future.whenComplete((result, t) -> this.autoBatchConfig.callback.accept(result));
        }
        this.futures.add((CompletableFuture<Result<ObjectGetResponse[]>>)future);
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> runBatchRecursively(List<WeaviateObject> batch, int connectionErrorCount, int timeoutErrorCount, List<ObjectGetResponse> combinedSingleResponses) {
        return Futures.handleAsync(this.internalRun(batch), (result, throwable) -> {
            List<ObjectGetResponse> tempCombinedSingleResponses = combinedSingleResponses;
            List tempBatch = batch;
            if (throwable != null) {
                boolean executeAgain = false;
                int tempConnCount = connectionErrorCount;
                int tempTimeCount = timeoutErrorCount;
                int delay = 0;
                if (throwable instanceof ConnectException) {
                    if (tempConnCount++ < this.batchRetriesConfig.maxConnectionRetries) {
                        executeAgain = true;
                        delay = tempConnCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                } else if (throwable instanceof SocketTimeoutException) {
                    Pair<List<ObjectGetResponse>, List<WeaviateObject>> pair = this.fetchCreatedAndBuildBatchToReRun(tempBatch);
                    tempCombinedSingleResponses = this.combineSingleResponses(tempCombinedSingleResponses, (List)pair.getLeft());
                    tempBatch = (List)pair.getRight();
                    if (ObjectUtils.isNotEmpty((Object)tempBatch) && tempTimeCount++ < this.batchRetriesConfig.maxTimeoutRetries) {
                        executeAgain = true;
                        delay = tempTimeCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                }
                if (executeAgain) {
                    try {
                        List<ObjectGetResponse> finalCombinedSingleResponses = tempCombinedSingleResponses;
                        List finalBatch = tempBatch;
                        int connCount = tempConnCount;
                        int timeCount = tempTimeCount;
                        return Futures.supplyDelayed(() -> this.runBatchRecursively(finalBatch, connCount, timeCount, finalCombinedSingleResponses), delay, this.executor);
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                }
            } else if (!result.hasErrors()) {
                tempBatch = null;
            }
            return CompletableFuture.completedFuture(this.createFinalResultFromLastResultAndCombinedSingleResponses((Result<ObjectGetResponse[]>)result, (Throwable)throwable, tempCombinedSingleResponses, tempBatch));
        }, this.executor);
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> internalRun(List<WeaviateObject> batch) {
        return this.config.useGRPC() ? this.internalGrpcRun(batch) : this.internalHttpRun(batch);
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> internalGrpcRun(List<WeaviateObject> batch) {
        BatchObjectConverter batchObjectConverter = new BatchObjectConverter(this.grpcVersionSupport);
        List batchObjects = batch.stream().map(batchObjectConverter::toBatchObject).collect(Collectors.toList());
        WeaviateProtoBatch.BatchObjectsRequest.Builder batchObjectsRequestBuilder = WeaviateProtoBatch.BatchObjectsRequest.newBuilder();
        batchObjectsRequestBuilder.addAllObjects(batchObjects);
        Optional.ofNullable(this.consistencyLevel).map(cl -> {
            switch (cl) {
                case "ALL": {
                    return WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_ALL;
                }
                case "QUORUM": {
                    return WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_QUORUM;
                }
            }
            return WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_ONE;
        }).ifPresent(batchObjectsRequestBuilder::setConsistencyLevel);
        WeaviateProtoBatch.BatchObjectsRequest batchObjectsRequest = batchObjectsRequestBuilder.build();
        return Futures.supplyAsync(() -> {
            AsyncGrpcClient grpcClient = AsyncGrpcClient.create(this.config, this.tokenProvider);
            try {
                WeaviateProtoBatch.BatchObjectsReply batchObjectsReply = (WeaviateProtoBatch.BatchObjectsReply)grpcClient.batchObjects(batchObjectsRequest).get();
                return batchObjectsReply;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
            finally {
                grpcClient.shutdown();
            }
        }, this.executor).thenApply(batchObjectsReply -> io.weaviate.client.v1.batch.api.ObjectsBatcher.resultFromBatchObjectsReply(batchObjectsReply, batch));
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> internalHttpRun(List<WeaviateObject> batch) {
        final CompletableFuture<Result<ObjectGetResponse[]>> future = new CompletableFuture<Result<ObjectGetResponse[]>>();
        ObjectsBatchRequestBody payload = ObjectsBatchRequestBody.builder().objects(batch.toArray(new WeaviateObject[0])).fields(new String[]{"ALL"}).build();
        String path = this.objectsPath.buildCreate(ObjectsPath.Params.builder().consistencyLevel(this.consistencyLevel).build());
        this.sendPostRequest(path, (Object)payload, ObjectGetResponse[].class, new FutureCallback<Result<ObjectGetResponse[]>>(){

            public void completed(Result<ObjectGetResponse[]> batchResult) {
                future.complete(batchResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private Pair<List<ObjectGetResponse>, List<WeaviateObject>> fetchCreatedAndBuildBatchToReRun(List<WeaviateObject> batch) {
        ArrayList<WeaviateObject> rerunBatch = new ArrayList<WeaviateObject>(batch.size());
        ArrayList<ObjectGetResponse> createdResponses = new ArrayList<ObjectGetResponse>(batch.size());
        ArrayList<CompletableFuture<Result<List<WeaviateObject>>>> futures = new ArrayList<CompletableFuture<Result<List<WeaviateObject>>>>(batch.size());
        for (WeaviateObject batchObject : batch) {
            futures.add(this.fetchExistingObject(batchObject));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        try {
            for (int i = 0; i < batch.size(); ++i) {
                CompletableFuture future = (CompletableFuture)futures.get(i);
                WeaviateObject batchObject = batch.get(i);
                if (future.isCompletedExceptionally()) {
                    rerunBatch.add(batchObject);
                    continue;
                }
                Result existingResult = (Result)future.get();
                if (existingResult.hasErrors() || ObjectUtils.isEmpty(existingResult.getResult())) {
                    rerunBatch.add(batchObject);
                    continue;
                }
                WeaviateObject existingObject = (WeaviateObject)((List)existingResult.getResult()).get(0);
                if (this.isDifferentObject(batchObject, existingObject)) {
                    rerunBatch.add(batchObject);
                    continue;
                }
                createdResponses.add(this.createResponseFromExistingObject(existingObject));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CompletionException(e);
        }
        return Pair.of(createdResponses, rerunBatch);
    }

    private CompletableFuture<Result<List<WeaviateObject>>> fetchExistingObject(WeaviateObject batchObject) {
        final CompletableFuture<Result<List<WeaviateObject>>> future = new CompletableFuture<Result<List<WeaviateObject>>>();
        this.data.objectsGetter().withID(batchObject.getId()).withClassName(batchObject.getClassName()).withVector().run(new FutureCallback<Result<List<WeaviateObject>>>(){

            public void completed(Result<List<WeaviateObject>> objectsResult) {
                future.complete(objectsResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private boolean isDifferentObject(WeaviateObject batchObject, WeaviateObject existingObject) {
        if (!(existingObject.getVector() == null && batchObject.getVector() == null || Arrays.equals((Object[])existingObject.getVector(), (Object[])batchObject.getVector()))) {
            return true;
        }
        Map<String, Object> existingProperties = existingObject.getProperties();
        Map<String, Object> batchProperties = batchObject.getProperties();
        if (existingProperties != null && batchProperties == null || existingProperties == null && batchProperties != null) {
            return true;
        }
        return existingProperties != null && !existingProperties.equals(batchProperties);
    }

    private ObjectGetResponse createResponseFromExistingObject(WeaviateObject existingObject) {
        ObjectsGetResponseAO2Result result = new ObjectsGetResponseAO2Result();
        result.setStatus("SUCCESS");
        ObjectGetResponse response = new ObjectGetResponse();
        response.setId(existingObject.getId());
        response.setClassName(existingObject.getClassName());
        response.setProperties(existingObject.getProperties());
        response.setAdditional(existingObject.getAdditional());
        response.setCreationTimeUnix(existingObject.getCreationTimeUnix());
        response.setLastUpdateTimeUnix(existingObject.getLastUpdateTimeUnix());
        response.setVector(existingObject.getVector());
        response.setVectors(existingObject.getVectors());
        response.setMultiVectors(existingObject.getMultiVectors());
        response.setVectorWeights(existingObject.getVectorWeights());
        response.setResult(result);
        return response;
    }

    private List<ObjectGetResponse> combineSingleResponses(List<ObjectGetResponse> combinedSingleResponses, List<ObjectGetResponse> createdResponses) {
        if (ObjectUtils.isNotEmpty(createdResponses)) {
            combinedSingleResponses = ObjectUtils.isEmpty(combinedSingleResponses) ? createdResponses : Stream.of(combinedSingleResponses, createdResponses).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return combinedSingleResponses;
    }

    private Result<ObjectGetResponse[]> createFinalResultFromLastResultAndCombinedSingleResponses(Result<ObjectGetResponse[]> lastResult, Throwable throwable, List<ObjectGetResponse> combinedSingleResponses, List<WeaviateObject> failedBatch) {
        List<WeaviateErrorMessage> messages;
        int statusCode = 0;
        if (throwable != null && lastResult == null) {
            lastResult = new Result<Object>(statusCode, null, WeaviateErrorResponse.builder().error(Collections.singletonList(WeaviateErrorMessage.builder().message(throwable.getMessage()).throwable(throwable).build())).code(statusCode).build());
        }
        if (ObjectUtils.isEmpty(failedBatch) && ObjectUtils.isEmpty(combinedSingleResponses)) {
            return lastResult;
        }
        Object[] allResponses = null;
        if (ObjectUtils.isNotEmpty((Object)lastResult.getResult())) {
            allResponses = lastResult.getResult();
        }
        if (ObjectUtils.isNotEmpty(combinedSingleResponses)) {
            allResponses = (ObjectGetResponse[])ArrayUtils.addAll((Object[])allResponses, (Object[])combinedSingleResponses.toArray(new ObjectGetResponse[0]));
        }
        if (ObjectUtils.isEmpty(failedBatch)) {
            return new Result<Object[]>(statusCode, allResponses, null);
        }
        String failedIds = failedBatch.stream().map(WeaviateObject::getId).collect(Collectors.joining(", "));
        WeaviateErrorMessage failedIdsMessage = WeaviateErrorMessage.builder().message("Failed ids: " + failedIds).build();
        if (lastResult.hasErrors()) {
            statusCode = lastResult.getError().getStatusCode();
            List<WeaviateErrorMessage> prevMessages = lastResult.getError().getMessages();
            messages = new ArrayList<WeaviateErrorMessage>(prevMessages.size() + 1);
            messages.addAll(prevMessages);
            messages.add(failedIdsMessage);
        } else {
            messages = Collections.singletonList(failedIdsMessage);
        }
        return new Result<Object[]>(statusCode, allResponses, WeaviateErrorResponse.builder().error(messages).code(statusCode).build());
    }

    public static class BatchRetriesConfig {
        public static final int MAX_TIMEOUT_RETRIES = 3;
        public static final int MAX_CONNECTION_RETRIES = 3;
        public static final int RETRIES_INTERVAL = 2000;
        private final int maxTimeoutRetries;
        private final int maxConnectionRetries;
        private final int retriesIntervalMs;

        private BatchRetriesConfig(int maxTimeoutRetries, int maxConnectionRetries, int retriesIntervalMs) {
            Assert.requireGreaterEqual(maxTimeoutRetries, 0, "maxTimeoutRetries");
            Assert.requireGreaterEqual(maxConnectionRetries, 0, "maxConnectionRetries");
            Assert.requireGreater(retriesIntervalMs, 0, "retriesIntervalMs");
            this.maxTimeoutRetries = maxTimeoutRetries;
            this.maxConnectionRetries = maxConnectionRetries;
            this.retriesIntervalMs = retriesIntervalMs;
        }

        public static BatchRetriesConfigBuilder defaultConfig() {
            return BatchRetriesConfig.builder().maxTimeoutRetries(3).maxConnectionRetries(3).retriesIntervalMs(2000);
        }

        @Generated
        public static BatchRetriesConfigBuilder builder() {
            return new BatchRetriesConfigBuilder();
        }

        @Generated
        public int getMaxTimeoutRetries() {
            return this.maxTimeoutRetries;
        }

        @Generated
        public int getMaxConnectionRetries() {
            return this.maxConnectionRetries;
        }

        @Generated
        public int getRetriesIntervalMs() {
            return this.retriesIntervalMs;
        }

        @Generated
        public String toString() {
            return "ObjectsBatcher.BatchRetriesConfig(maxTimeoutRetries=" + this.getMaxTimeoutRetries() + ", maxConnectionRetries=" + this.getMaxConnectionRetries() + ", retriesIntervalMs=" + this.getRetriesIntervalMs() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchRetriesConfig)) {
                return false;
            }
            BatchRetriesConfig other = (BatchRetriesConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTimeoutRetries() != other.getMaxTimeoutRetries()) {
                return false;
            }
            if (this.getMaxConnectionRetries() != other.getMaxConnectionRetries()) {
                return false;
            }
            return this.getRetriesIntervalMs() == other.getRetriesIntervalMs();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BatchRetriesConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTimeoutRetries();
            result = result * 59 + this.getMaxConnectionRetries();
            result = result * 59 + this.getRetriesIntervalMs();
            return result;
        }

        @Generated
        public static class BatchRetriesConfigBuilder {
            @Generated
            private int maxTimeoutRetries;
            @Generated
            private int maxConnectionRetries;
            @Generated
            private int retriesIntervalMs;

            @Generated
            BatchRetriesConfigBuilder() {
            }

            @Generated
            public BatchRetriesConfigBuilder maxTimeoutRetries(int maxTimeoutRetries) {
                this.maxTimeoutRetries = maxTimeoutRetries;
                return this;
            }

            @Generated
            public BatchRetriesConfigBuilder maxConnectionRetries(int maxConnectionRetries) {
                this.maxConnectionRetries = maxConnectionRetries;
                return this;
            }

            @Generated
            public BatchRetriesConfigBuilder retriesIntervalMs(int retriesIntervalMs) {
                this.retriesIntervalMs = retriesIntervalMs;
                return this;
            }

            @Generated
            public BatchRetriesConfig build() {
                return new BatchRetriesConfig(this.maxTimeoutRetries, this.maxConnectionRetries, this.retriesIntervalMs);
            }

            @Generated
            public String toString() {
                return "ObjectsBatcher.BatchRetriesConfig.BatchRetriesConfigBuilder(maxTimeoutRetries=" + this.maxTimeoutRetries + ", maxConnectionRetries=" + this.maxConnectionRetries + ", retriesIntervalMs=" + this.retriesIntervalMs + ")";
            }
        }
    }

    public static class AutoBatchConfig {
        public static final int BATCH_SIZE = 100;
        private final int batchSize;
        private final Consumer<Result<ObjectGetResponse[]>> callback;

        private AutoBatchConfig(int batchSize, Consumer<Result<ObjectGetResponse[]>> callback) {
            Assert.requireGreaterEqual(batchSize, 1, "batchSize");
            this.batchSize = batchSize;
            this.callback = callback;
        }

        public static AutoBatchConfigBuilder defaultConfig() {
            return AutoBatchConfig.builder().batchSize(100).callback(null);
        }

        @Generated
        public static AutoBatchConfigBuilder builder() {
            return new AutoBatchConfigBuilder();
        }

        @Generated
        public int getBatchSize() {
            return this.batchSize;
        }

        @Generated
        public Consumer<Result<ObjectGetResponse[]>> getCallback() {
            return this.callback;
        }

        @Generated
        public String toString() {
            return "ObjectsBatcher.AutoBatchConfig(batchSize=" + this.getBatchSize() + ", callback=" + this.getCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutoBatchConfig)) {
                return false;
            }
            AutoBatchConfig other = (AutoBatchConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBatchSize() != other.getBatchSize()) {
                return false;
            }
            Consumer<Result<ObjectGetResponse[]>> this$callback = this.getCallback();
            Consumer<Result<ObjectGetResponse[]>> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutoBatchConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBatchSize();
            Consumer<Result<ObjectGetResponse[]>> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        @Generated
        public static class AutoBatchConfigBuilder {
            @Generated
            private int batchSize;
            @Generated
            private Consumer<Result<ObjectGetResponse[]>> callback;

            @Generated
            AutoBatchConfigBuilder() {
            }

            @Generated
            public AutoBatchConfigBuilder batchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            @Generated
            public AutoBatchConfigBuilder callback(Consumer<Result<ObjectGetResponse[]>> callback) {
                this.callback = callback;
                return this;
            }

            @Generated
            public AutoBatchConfig build() {
                return new AutoBatchConfig(this.batchSize, this.callback);
            }

            @Generated
            public String toString() {
                return "ObjectsBatcher.AutoBatchConfig.AutoBatchConfigBuilder(batchSize=" + this.batchSize + ", callback=" + this.callback + ")";
            }
        }
    }
}

