/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ContentLengthHeader;

public class ContentLength
extends SIPHeader
implements ContentLengthHeader {
    private static final long serialVersionUID = 1187190542411037027L;
    protected Integer contentLength;

    public ContentLength() {
        super("Content-Length");
    }

    public ContentLength(int length) {
        super("Content-Length");
        this.contentLength = new Integer(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) throws InvalidArgumentException {
        if (contentLength < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, ContentLength, setContentLength(), the contentLength parameter is <0");
        }
        this.contentLength = new Integer(contentLength);
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer buffer) {
        if (this.contentLength == null) {
            buffer.append("0");
        } else {
            buffer.append(this.contentLength.toString());
        }
        return buffer;
    }

    public boolean match(Object other) {
        return other instanceof ContentLength;
    }

    public boolean equals(Object other) {
        if (other instanceof ContentLengthHeader) {
            ContentLengthHeader o = (ContentLengthHeader)other;
            return this.getContentLength() == o.getContentLength();
        }
        return false;
    }
}

