/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dreamlu.mica.core.beans.MicaBeanCopier;
import net.dreamlu.mica.core.beans.MicaBeanMap;
import net.dreamlu.mica.core.convert.MicaConverter;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.utils.BeanDiff;
import net.dreamlu.mica.core.utils.BeanProperty;
import net.dreamlu.mica.core.utils.ClassUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FastByteArrayOutputStream;

public final class BeanUtil
extends BeanUtils {
    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class clazz = ClassUtil.forName((String)clazzStr, null);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e);
        }
    }

    @Nullable
    public static Object getProperty(@Nullable Object bean, String propertyName) {
        if (bean == null) {
            return null;
        }
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        return beanWrapper.getPropertyValue(propertyName);
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)Objects.requireNonNull(bean, "bean Could not null"));
        beanWrapper.setPropertyValue(propertyName, value);
    }

    @Nullable
    public static <T> T clone(@Nullable T source) {
        if (source == null) {
            return null;
        }
        return (T)BeanUtil.copy(source, source.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T deepClone(@Nullable T source) {
        Throwable throwable;
        if (source == null) {
            return null;
        }
        FastByteArrayOutputStream fBos = new FastByteArrayOutputStream(1024);
        try {
            throwable = null;
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)fBos);){
                oos.writeObject(source);
                oos.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + source.getClass(), ex);
        }
        try {
            throwable = null;
            try (ObjectInputStream ois = new ObjectInputStream(fBos.getInputStream());){
                Object object = ois.readObject();
                return (T)object;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalArgumentException("Failed to deserialize object", ex);
        }
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        return BeanUtil.copy(source, source.getClass(), clazz);
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class sourceClazz, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        MicaBeanCopier copier = MicaBeanCopier.create(sourceClazz, targetClazz, false);
        T to = BeanUtil.newInstance(targetClazz);
        copier.copy(source, to, null);
        return to;
    }

    public static <T> List<T> copy(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        return BeanUtil.copy(sourceList, (List)null, targetClazz);
    }

    public static <T> List<T> copy(@Nullable Collection<?> sourceList, @Nullable List<T> targetList, Class<T> targetClazz) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        if (targetList == null) {
            targetList = new ArrayList<T>(sourceList.size());
        }
        Class<?> sourceClazz = null;
        for (Object source : sourceList) {
            if (source == null) continue;
            if (sourceClazz == null) {
                sourceClazz = source.getClass();
            }
            T bean = BeanUtil.copy(source, sourceClazz, targetClazz);
            targetList.add(bean);
        }
        return targetList;
    }

    public static void copy(@Nullable Object source, @Nullable Object targetBean) {
        if (source == null || targetBean == null) {
            return;
        }
        MicaBeanCopier copier = MicaBeanCopier.create(source.getClass(), targetBean.getClass(), false);
        copier.copy(source, targetBean, null);
    }

    public static void copyNonNull(@Nullable Object source, @Nullable Object targetBean) {
        if (source == null || targetBean == null) {
            return;
        }
        MicaBeanCopier copier = MicaBeanCopier.create(source.getClass(), targetBean.getClass(), false, true);
        copier.copy(source, targetBean, null);
    }

    @Nullable
    public static <T> T copyWithConvert(@Nullable Object source, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        return BeanUtil.copyWithConvert(source, source.getClass(), targetClazz);
    }

    @Nullable
    public static <T> T copyWithConvert(@Nullable Object source, Class<?> sourceClazz, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        MicaBeanCopier copier = MicaBeanCopier.create(sourceClazz, targetClazz, true);
        T to = BeanUtil.newInstance(targetClazz);
        copier.copy(source, to, new MicaConverter(sourceClazz, targetClazz));
        return to;
    }

    public static <T> List<T> copyWithConvert(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        Class<?> sourceClazz = null;
        for (Object source : sourceList) {
            if (source == null) continue;
            if (sourceClazz == null) {
                sourceClazz = source.getClass();
            }
            T bean = BeanUtil.copyWithConvert(source, sourceClazz, targetClazz);
            outList.add(bean);
        }
        return outList;
    }

    @Nullable
    public static <T> T copyProperties(@Nullable Object source, Class<T> targetClazz) throws BeansException {
        if (source == null) {
            return null;
        }
        T to = BeanUtil.newInstance(targetClazz);
        BeanUtil.copyProperties((Object)source, to);
        return to;
    }

    public static <T> List<T> copyProperties(@Nullable Collection<?> sourceList, Class<T> targetClazz) throws BeansException {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        for (Object source : sourceList) {
            if (source == null) continue;
            T bean = BeanUtil.copyProperties(source, targetClazz);
            outList.add(bean);
        }
        return outList;
    }

    public static Map<String, Object> toMap(@Nullable Object bean) {
        if (bean == null) {
            return new HashMap<String, Object>(0);
        }
        return MicaBeanMap.create(bean);
    }

    public static Map<String, Object> toNewMap(@Nullable Object bean) {
        return new HashMap<String, Object>(BeanUtil.toMap(bean));
    }

    public static <T> T toBean(Map<String, Object> beanMap, Class<T> valueType) {
        Objects.requireNonNull(beanMap, "beanMap Could not null");
        T to = BeanUtil.newInstance(valueType);
        if (beanMap.isEmpty()) {
            return to;
        }
        BeanUtil.copy(beanMap, to);
        return to;
    }

    @Nullable
    public static Object generator(@Nullable Object superBean, BeanProperty ... props) {
        if (superBean == null) {
            return null;
        }
        Class<?> superclass = superBean.getClass();
        Object genBean = BeanUtil.generator(superclass, props);
        BeanUtil.copy(superBean, genBean);
        return genBean;
    }

    public static Object generator(Class<?> superclass, BeanProperty ... props) {
        BeanGenerator generator = new BeanGenerator();
        generator.setSuperclass(superclass);
        generator.setUseCache(true);
        generator.setContextClass(superclass);
        for (BeanProperty prop : props) {
            generator.addProperty(prop.getName(), prop.getType());
        }
        return generator.create();
    }

    public static BeanDiff diff(Object src, Object dist) {
        Assert.notNull((Object)src, (String)"diff Object src is null.");
        Assert.notNull((Object)src, (String)"diff Object dist is null.");
        return BeanUtil.diff(BeanUtil.toMap(src), BeanUtil.toMap(dist));
    }

    public static BeanDiff diff(Map<String, Object> src, Map<String, Object> dist) {
        Assert.notNull(src, (String)"diff Map src is null.");
        Assert.notNull(src, (String)"diff Map dist is null.");
        HashMap<String, Object> difference = new HashMap<String, Object>(8);
        difference.putAll(src);
        difference.putAll(dist);
        difference.entrySet().removeAll(src.entrySet());
        HashMap oldValues = new HashMap(8);
        difference.keySet().forEach(k -> oldValues.put(k, src.get(k)));
        BeanDiff diff = new BeanDiff();
        diff.getFields().addAll(difference.keySet());
        diff.getOldValues().putAll(oldValues);
        diff.getNewValues().putAll(difference);
        return diff;
    }

    private BeanUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

