/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class StringBooleanToPredicateConverter
implements Converter<String, Predicate> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringBooleanToPredicateConverter.class);

    public Predicate convert(String source) {
        String trimmed = StringSupport.trimOrNull((String)source);
        if (Boolean.valueOf(trimmed).booleanValue()) {
            return Predicates.alwaysTrue();
        }
        if (trimmed != null) {
            if ("1".equals(trimmed)) {
                this.log.warn("The value '1' is not treated as 'true'; if intentional, explicitly use 'false'");
            } else if (!"false".equalsIgnoreCase(trimmed) && !"0".equals(trimmed)) {
                this.log.warn("Unrecognized value '{}' converted to false; if intentional, explicitly use 'false'", (Object)trimmed);
            }
        }
        return Predicates.alwaysFalse();
    }
}

