/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.error;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public class ErrorRaisingController {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ErrorRaisingController.class);

    @RequestMapping
    public void raiseError(@Nonnull HttpServletRequest httpRequest) throws Throwable {
        Object uri = httpRequest.getAttribute("javax.servlet.error.request_uri");
        Object exception = httpRequest.getAttribute("javax.servlet.error.exception");
        if (exception == null || !(exception instanceof Exception)) {
            this.log.error("No exception found in request attribute, raising a generic error");
            throw new IllegalArgumentException("No exception found in request attribute");
        }
        Exception e = (Exception)exception;
        this.log.error("Propagating exception thrown by request to {}", uri);
        if (e.getCause() != null) {
            throw e.getCause();
        }
        throw e;
    }
}

