/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class RESTDataStore {
    private final Element dsElem;

    public static RESTDataStore build(String xml) {
        if (xml == null) {
            return null;
        }
        Element e = JDOMBuilder.buildElement(xml);
        if (e != null) {
            return new RESTDataStore(e);
        }
        return null;
    }

    protected RESTDataStore(Element dsElem) {
        this.dsElem = dsElem;
    }

    public String getName() {
        return this.dsElem.getChildText("name");
    }

    public String getStoreType() {
        return this.dsElem.getChildText("type");
    }

    public String getDescription() {
        return this.dsElem.getChildText("description");
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.dsElem.getChildText("enabled"));
    }

    public String getWorkspaceName() {
        return this.dsElem.getChild("workspace").getChildText("name");
    }

    public Map<String, String> getConnectionParameters() {
        Element elConnparm = this.dsElem.getChild("connectionParameters");
        if (elConnparm != null) {
            List elements = elConnparm.getChildren("entry");
            HashMap<String, String> params = new HashMap<String, String>(elements.size());
            for (Element element : elements) {
                String key = element.getAttributeValue("key");
                String value = element.getTextTrim();
                params.put(key, value);
            }
            return params;
        }
        return null;
    }

    protected String getConnectionParameter(String paramName) {
        Element elConnparm = this.dsElem.getChild("connectionParameters");
        if (elConnparm != null) {
            for (Element entry : elConnparm.getChildren("entry")) {
                String key = entry.getAttributeValue("key");
                if (!paramName.equals(key)) continue;
                return entry.getTextTrim();
            }
        }
        return null;
    }

    public DBType getType() {
        return DBType.get(this.getConnectionParameter("dbtype"));
    }

    public static enum DBType {
        POSTGIS("postgis"),
        ORACLE("oracle"),
        SHP("shp"),
        UNKNOWN(null);

        private final String restName;

        private DBType(String restName) {
            this.restName = restName;
        }

        public static DBType get(String restName) {
            for (DBType type : DBType.values()) {
                if (type == UNKNOWN || !type.restName.equals(restName)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

