/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTResource;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMListIterator;
import it.geosolutions.geoserver.rest.encoder.feature.FeatureTypeAttribute;
import it.geosolutions.geoserver.rest.encoder.feature.GSAttributeEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class RESTFeatureType
extends RESTResource {
    public static RESTFeatureType build(String response) {
        Element elem = JDOMBuilder.buildElement(response);
        return elem == null ? null : new RESTFeatureType(elem);
    }

    public RESTFeatureType(Element resource) {
        super(resource);
    }

    public RESTFeatureType(RESTResource resource) {
        super(resource.rootElem);
    }

    public Iterable<Attribute> getAttributes() {
        return new Iterable<Attribute>(){

            @Override
            public Iterator<Attribute> iterator() {
                return RESTFeatureType.this.attributesIterator();
            }
        };
    }

    public Iterator<Attribute> attributesIterator() {
        Element attrs = this.rootElem.getChild("attributes");
        return new JDOMListIterator<Attribute>(attrs.getChildren()){

            @Override
            public Attribute transform(Element listItem) {
                Attribute ret = new Attribute();
                ret.setName(listItem.getChildText("name"));
                ret.setBinding(listItem.getChildText("binding"));
                return ret;
            }
        };
    }

    @Override
    public List<Map<FeatureTypeAttribute, String>> getAttributeList() {
        List attrs;
        ArrayList attrsList = null;
        Element attrsRoot = this.rootElem.getChild("attributes");
        if (attrsRoot != null && (attrs = attrsRoot.getChildren()) != null) {
            attrsList = new ArrayList(attrs.size());
            for (Element attr : attrs) {
                HashMap<FeatureTypeAttribute, String> attrsMap = new HashMap<FeatureTypeAttribute, String>();
                attrsList.add(attrsMap);
                for (FeatureTypeAttribute at : FeatureTypeAttribute.values()) {
                    String key = at.toString();
                    attrsMap.put(at, attr.getChildText(key));
                }
            }
        }
        return attrsList;
    }

    @Override
    public List<GSAttributeEncoder> getEncodedAttributeList() {
        List attrs;
        ArrayList<GSAttributeEncoder> attrsList = null;
        Element attrsRoot = this.rootElem.getChild("attributes");
        if (attrsRoot != null && (attrs = attrsRoot.getChildren()) != null) {
            attrsList = new ArrayList<GSAttributeEncoder>(attrs.size());
            for (Element attr : attrs) {
                GSAttributeEncoder attrEnc = new GSAttributeEncoder();
                for (FeatureTypeAttribute at : FeatureTypeAttribute.values()) {
                    String key = at.toString();
                    attrEnc.setAttribute(at, attr.getChildText(key));
                }
                attrsList.add(attrEnc);
            }
        }
        return attrsList;
    }

    public static class Attribute {
        private String name;
        private String binding;

        public String getBinding() {
            return this.binding;
        }

        public void setBinding(String binding) {
            this.binding = binding;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

