/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Content;
import org.jdom.Element;

public class GSLayerGroupEncoder
extends PropertyXMLEncoder {
    protected Element nameElem;
    protected Element workspaceElem;
    protected Element boundsElem;
    protected Element publishablesElem;
    protected Element stylesElem;

    public GSLayerGroupEncoder() {
        super("layerGroup");
    }

    public void setWorkspace(String workspace) {
        this.workspaceElem = this.elem("workspace", this.elem("name", workspace));
    }

    public void setName(String name) {
        this.nameElem = this.elem("name", name);
    }

    public void addLayer(String layer) {
        this.addLayer(layer, null);
    }

    public void addLayer(String layer, String styleName) {
        this.initPublishables("layers");
        this.publishablesElem.addContent((Content)this.elem("layer", this.elem("name", layer)));
        Element style = new Element("style");
        this.stylesElem.addContent((Content)style);
        if (styleName != null) {
            style.addContent((Content)this.elem("name", styleName));
        }
    }

    public void setBounds(String crs, double minx, double maxx, double miny, double maxy) {
        this.boundsElem = this.elem("bounds", this.elem("minx", Double.toString(minx)), this.elem("maxx", Double.toString(maxx)), this.elem("miny", Double.toString(miny)), this.elem("maxy", Double.toString(maxy)), this.elem("crs", "class", "projected").setText(crs));
    }

    protected void initPublishables(String publishablesTag) {
        if (this.publishablesElem == null) {
            this.publishablesElem = new Element(publishablesTag);
        }
        if (this.stylesElem == null) {
            this.stylesElem = new Element("styles");
        }
    }

    protected void addToRoot(Element ... elements) {
        for (Element e : elements) {
            if (e == null) continue;
            this.getRoot().addContent((Content)e);
        }
    }

    protected Element elem(String tag, String attributeName, String attributeValue) {
        return new Element(tag).setAttribute(attributeName, attributeValue);
    }

    protected Element elem(String tag, String text) {
        return new Element(tag).setText(text);
    }

    protected Element elem(String tag, Element ... children) {
        Element parent = new Element(tag);
        for (Element child : children) {
            parent.addContent((Content)child);
        }
        return parent;
    }

    @Override
    public String toString() {
        this.addToRoot(this.nameElem, this.workspaceElem, this.boundsElem, this.publishablesElem, this.stylesElem);
        return super.toString();
    }
}

