/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import java.net.URI;

public class GSNamespaceEncoder
extends PropertyXMLEncoder {
    public static final String NAMESPACE = "namespace";
    public static final String PREFIX = "prefix";
    public static final String URI = "uri";

    public GSNamespaceEncoder(String prefix, URI uri) {
        super(NAMESPACE);
        GSNamespaceEncoder.ensureValidPrefix(prefix);
        GSNamespaceEncoder.ensureValidURI(uri);
        this.add(PREFIX, prefix);
        this.add(URI, uri.toString());
    }

    public String getPrefix() {
        return ElementUtils.contains(this.getRoot(), PREFIX).getTextTrim();
    }

    public void setPrefix(String prefix) {
        GSNamespaceEncoder.ensureValidPrefix(prefix);
        ElementUtils.contains(this.getRoot(), PREFIX).setText(prefix);
    }

    public URI getURI() {
        String sUri = ElementUtils.contains(this.getRoot(), URI).getTextTrim();
        return java.net.URI.create(sUri);
    }

    public void setURI(URI uri) {
        GSNamespaceEncoder.ensureValidURI(uri);
        String sUri = uri.toString();
        ElementUtils.contains(this.getRoot(), URI).setText(sUri);
    }

    private static void ensureValidPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("Namespace prefix cannot be null or empty");
        }
    }

    private static void ensureValidURI(URI uri) {
        if (uri == null || uri.toString().isEmpty()) {
            throw new IllegalArgumentException("Namespace uri cannot be null or empty");
        }
    }
}

