/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.gui.visualize.PrintableComponent;
import weka.gui.visualize.PrintablePanel;

public class AttributeVisualizationPanel
extends PrintablePanel {
    private static final long serialVersionUID = -8650490488825371193L;
    protected Instances m_data;
    protected AttributeStats m_as;
    protected AttributeStats[] m_asCache;
    protected int m_attribIndex;
    protected double m_maxValue;
    protected double[] m_histBarCounts;
    SparseInstance[] m_histBarClassCounts;
    protected double m_barRange;
    protected int m_classIndex;
    private Thread m_hc;
    private boolean m_threadRun = false;
    private boolean m_doneCurrentAttribute = false;
    private boolean m_displayCurrentAttribute = false;
    protected JComboBox m_colorAttrib;
    private final FontMetrics m_fm;
    private final Integer m_locker = new Integer(1);
    private final ArrayList<Color> m_colorList = new ArrayList();
    private static final Color[] m_defaultColors = new Color[]{Color.blue, Color.red, Color.cyan, new Color(75, 123, 130), Color.pink, Color.green, Color.orange, new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0)};

    public AttributeVisualizationPanel() {
        this(false);
    }

    public AttributeVisualizationPanel(boolean showColouringOption) {
        this.setFont(new Font("Default", 0, 9));
        this.m_fm = this.getFontMetrics(this.getFont());
        this.setToolTipText("");
        FlowLayout fl = new FlowLayout(0);
        this.setLayout(fl);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                if (AttributeVisualizationPanel.this.m_data != null) {
                    // empty if block
                }
            }
        });
        this.m_colorAttrib = new JComboBox();
        this.m_colorAttrib.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    AttributeVisualizationPanel.this.m_classIndex = AttributeVisualizationPanel.this.m_colorAttrib.getSelectedIndex() - 1;
                    if (AttributeVisualizationPanel.this.m_as != null) {
                        AttributeVisualizationPanel.this.setAttribute(AttributeVisualizationPanel.this.m_attribIndex);
                    }
                }
            }
        });
        if (showColouringOption) {
            this.add(this.m_colorAttrib);
            this.validate();
        }
    }

    public void setInstances(Instances newins) {
        this.m_attribIndex = 0;
        this.m_as = null;
        this.m_data = new Instances(newins);
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.removeAllItems();
            this.m_colorAttrib.addItem("No class");
            for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                String type = "(" + Attribute.typeToStringShort(this.m_data.attribute(i)) + ")";
                this.m_colorAttrib.addItem(new String("Class: " + this.m_data.attribute(i).name() + " " + type));
            }
            if (this.m_data.classIndex() >= 0) {
                this.m_colorAttrib.setSelectedIndex(this.m_data.classIndex() + 1);
            } else {
                this.m_colorAttrib.setSelectedIndex(this.m_data.numAttributes());
            }
        }
        this.m_classIndex = this.m_data.classIndex() >= 0 ? this.m_data.classIndex() : this.m_data.numAttributes() - 1;
        this.m_asCache = new AttributeStats[this.m_data.numAttributes()];
    }

    public JComboBox getColorBox() {
        return this.m_colorAttrib;
    }

    public int getColoringIndex() {
        return this.m_classIndex;
    }

    public void setColoringIndex(int ci) {
        this.m_classIndex = ci;
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.setSelectedIndex(ci + 1);
        } else {
            this.setAttribute(this.m_attribIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int index) {
        Integer n = this.m_locker;
        synchronized (n) {
            this.m_threadRun = false;
            this.m_doneCurrentAttribute = false;
            this.m_displayCurrentAttribute = true;
            this.m_attribIndex = index;
            if (this.m_asCache[index] != null) {
                this.m_as = this.m_asCache[index];
            } else {
                this.m_asCache[index] = this.m_data.attributeStats(index);
                this.m_as = this.m_asCache[index];
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcGraph(int panelWidth, int panelHeight) {
        Integer n = this.m_locker;
        synchronized (n) {
            this.m_threadRun = true;
            if (this.m_as.nominalWeights != null) {
                this.m_hc = new BarCalc(panelWidth, panelHeight);
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else if (this.m_as.numericStats != null) {
                this.m_hc = new HistCalc();
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else {
                this.m_histBarCounts = null;
                this.m_histBarClassCounts = null;
                this.m_doneCurrentAttribute = true;
                this.m_threadRun = false;
                this.repaint();
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        if (this.m_as != null && this.m_as.nominalWeights != null) {
            float intervalWidth = (float)this.getWidth() / (float)this.m_as.nominalWeights.length;
            int x = 0;
            int barWidth = intervalWidth > 5.0f ? (int)Math.floor(intervalWidth * 0.8f) : 1;
            x += (int)(Math.floor(intervalWidth * 0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.1f));
            if (this.getWidth() - (this.m_as.nominalWeights.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_as.nominalWeights.length) > 2) {
                x += (this.getWidth() - (this.m_as.nominalWeights.length * barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f)) * this.m_as.nominalWeights.length)) / 2;
            }
            for (int i = 0; i < this.m_as.nominalWeights.length; ++i) {
                double heightRatio = ((double)this.getHeight() - (double)this.m_fm.getHeight()) / this.m_maxValue;
                if (ev.getX() >= x && ev.getX() <= x + barWidth && (long)ev.getY() >= (long)this.getHeight() - Math.round(this.m_as.nominalWeights[i] * heightRatio)) {
                    return this.m_data.attribute(this.m_attribIndex).value(i) + " [" + Utils.doubleToString(this.m_as.nominalWeights[i], 3) + "]";
                }
                x = x + barWidth + (int)(Math.floor(intervalWidth * 0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * 0.2f));
            }
        } else if (!(this.m_threadRun || this.m_histBarCounts == null && this.m_histBarClassCounts == null)) {
            int x = 0;
            double bar = this.m_as.numericStats.min;
            if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                int barWidth = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                x = 3;
                if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                    x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                }
                if (ev.getX() - x >= 0) {
                    int temp = (int)((double)(ev.getX() - x) / ((double)barWidth + 1.0E-10));
                    if (temp == 0) {
                        double sum = 0.0;
                        for (int k = 0; k < this.m_histBarClassCounts[0].numValues(); ++k) {
                            sum += this.m_histBarClassCounts[0].valueSparse(k);
                        }
                        return "<html><center><font face=Dialog size=-1>" + Utils.doubleToString(sum, 3) + "<br>" + "[" + Utils.doubleToString(bar + this.m_barRange * (double)temp, 3) + ", " + Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3) + "]" + "</font></center></html>";
                    }
                    if (temp < this.m_histBarClassCounts.length) {
                        double sum = 0.0;
                        for (int k = 0; k < this.m_histBarClassCounts[temp].numValues(); ++k) {
                            sum += this.m_histBarClassCounts[temp].valueSparse(k);
                        }
                        return "<html><center><font face=Dialog size=-1>" + Utils.doubleToString(sum, 3) + "<br>(" + Utils.doubleToString(bar + this.m_barRange * (double)temp, 3) + ", " + Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3) + "]</font></center></html>";
                    }
                }
            } else {
                int barWidth = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                x = 3;
                if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                    x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                }
                if (ev.getX() - x >= 0) {
                    int temp = (int)((double)(ev.getX() - x) / ((double)barWidth + 1.0E-10));
                    if (temp == 0) {
                        return "<html><center><font face=Dialog size=-1>" + this.m_histBarCounts[0] + "<br>" + "[" + Utils.doubleToString(bar + this.m_barRange * (double)temp, 3) + ", " + Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3) + "]" + "</font></center></html>";
                    }
                    if (temp < this.m_histBarCounts.length) {
                        return "<html><center><font face=Dialog size=-1>" + this.m_histBarCounts[temp] + "<br>" + "(" + Utils.doubleToString(bar + this.m_barRange * (double)temp, 3) + ", " + Utils.doubleToString(bar + this.m_barRange * (double)(temp + 1), 3) + "]" + "</font></center></html>";
                    }
                }
            }
        }
        return PrintableComponent.getToolTipText(this.m_Printer);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        if (this.m_as != null) {
            if (!this.m_doneCurrentAttribute && !this.m_threadRun) {
                this.calcGraph(this.getWidth(), this.getHeight());
            }
            if (!this.m_threadRun && this.m_displayCurrentAttribute) {
                int buttonHeight = 0;
                if (this.m_colorAttrib != null) {
                    buttonHeight = this.m_colorAttrib.getHeight() + this.m_colorAttrib.getLocation().y;
                }
                if (this.m_as.nominalWeights != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int x = 0;
                    int y = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        double intervalWidth = (float)this.getWidth() / (float)this.m_histBarClassCounts.length;
                        int barWidth = intervalWidth > 5.0 ? (int)Math.floor(intervalWidth * (double)0.8f) : 1;
                        x += (int)(Math.floor(intervalWidth * (double)0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.1f));
                        if (this.getWidth() - (this.m_histBarClassCounts.length * barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f)) * this.m_histBarClassCounts.length) > 2) {
                            x += (this.getWidth() - (this.m_histBarClassCounts.length * barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f)) * this.m_histBarClassCounts.length)) / 2;
                        }
                        double sum = 0.0;
                        for (SparseInstance m_histBarClassCount : this.m_histBarClassCounts) {
                            double heightRatio = ((double)this.getHeight() - (double)this.m_fm.getHeight() - (double)buttonHeight) / this.m_maxValue;
                            y = this.getHeight();
                            if (m_histBarClassCount != null) {
                                for (int j = 0; j < m_histBarClassCount.numAttributes(); ++j) {
                                    sum += m_histBarClassCount.value(j);
                                    y = (int)((long)y - Math.round(m_histBarClassCount.value(j) * heightRatio));
                                    g.setColor(this.m_colorList.get(j));
                                    g.fillRect(x, y, barWidth, (int)Math.round(m_histBarClassCount.value(j) * heightRatio));
                                    g.setColor(Color.black);
                                }
                            }
                            if ((double)this.m_fm.stringWidth(Utils.doubleToString(sum, 1)) < intervalWidth) {
                                g.drawString(Utils.doubleToString(sum, 1), x, y - 1);
                            }
                            x = x + barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f));
                            sum = 0.0;
                        }
                    } else {
                        double intervalWidth = (float)this.getWidth() / (float)this.m_histBarCounts.length;
                        int barWidth = intervalWidth > 5.0 ? (int)Math.floor(intervalWidth * (double)0.8f) : 1;
                        x += (int)(Math.floor(intervalWidth * (double)0.1f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.1f));
                        if (this.getWidth() - (this.m_histBarCounts.length * barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f)) * this.m_histBarCounts.length) > 2) {
                            x += (this.getWidth() - (this.m_histBarCounts.length * barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f)) * this.m_histBarCounts.length)) / 2;
                        }
                        for (double m_histBarCount : this.m_histBarCounts) {
                            double heightRatio = (double)((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight) / this.m_maxValue;
                            y = (int)((long)this.getHeight() - Math.round(m_histBarCount * heightRatio));
                            g.fillRect(x, y, barWidth, (int)Math.round(m_histBarCount * heightRatio));
                            if ((double)this.m_fm.stringWidth(Utils.doubleToString(m_histBarCount, 1)) < intervalWidth) {
                                g.drawString(Utils.doubleToString(m_histBarCount, 1), x, y - 1);
                            }
                            x = x + barWidth + (int)(Math.floor(intervalWidth * (double)0.2f) < 1.0 ? 1.0 : Math.floor(intervalWidth * (double)0.2f));
                        }
                    }
                } else if (this.m_as.numericStats != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int x = 0;
                    int y = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        int barWidth = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                        }
                        for (SparseInstance m_histBarClassCount : this.m_histBarClassCounts) {
                            if (m_histBarClassCount == null) continue;
                            double heightRatio = (double)((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight - 19.0f) / this.m_maxValue;
                            y = this.getHeight() - 19;
                            double sum = 0.0;
                            for (int j = 0; j < m_histBarClassCount.numValues(); ++j) {
                                y = (int)((long)y - Math.round(m_histBarClassCount.valueSparse(j) * heightRatio));
                                g.setColor(this.m_colorList.get(m_histBarClassCount.index(j)));
                                if (barWidth > 1) {
                                    g.fillRect(x, y, barWidth, (int)Math.round(m_histBarClassCount.valueSparse(j) * heightRatio));
                                } else if (m_histBarClassCount.valueSparse(j) * heightRatio > 0.0) {
                                    g.drawLine(x, y, x, (int)((long)y + Math.round(m_histBarClassCount.valueSparse(j) * heightRatio)));
                                }
                                g.setColor(Color.black);
                                sum += m_histBarClassCount.valueSparse(j);
                            }
                            if (this.m_fm.stringWidth(" " + Utils.doubleToString(sum, 1)) < barWidth) {
                                g.drawString(" " + Utils.doubleToString(sum, 1), x, y - 1);
                            }
                            x += barWidth;
                        }
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarClassCounts.length * barWidth)) / 2;
                        }
                        g.drawLine(x, this.getHeight() - 17, barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 17);
                        g.drawLine(x, this.getHeight() - 16, x, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), x, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(x + barWidth * this.m_histBarClassCounts.length / 2, this.getHeight() - 16, x + barWidth * this.m_histBarClassCounts.length / 2, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), x + barWidth * this.m_histBarClassCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 16, barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - 1 : x + barWidth * this.m_histBarClassCounts.length, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), barWidth == 1 ? x + barWidth * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : x + barWidth * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    } else {
                        int barWidth = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                        }
                        for (double m_histBarCount : this.m_histBarCounts) {
                            double heightRatio = (double)((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)buttonHeight - 19.0f) / this.m_maxValue;
                            y = (int)((long)this.getHeight() - Math.round(m_histBarCount * heightRatio) - 19L);
                            if (barWidth > 1) {
                                g.drawRect(x, y, barWidth, (int)Math.round(m_histBarCount * heightRatio));
                            } else if (m_histBarCount * heightRatio > 0.0) {
                                g.drawLine(x, y, x, (int)((long)y + Math.round(m_histBarCount * heightRatio)));
                            }
                            if (this.m_fm.stringWidth(" " + Utils.doubleToString(m_histBarCount, 1)) < barWidth) {
                                g.drawString(" " + Utils.doubleToString(m_histBarCount, 1), x, y - 1);
                            }
                            x += barWidth;
                        }
                        x = 3;
                        if (this.getWidth() - (x + this.m_histBarCounts.length * barWidth) > 5) {
                            x += (this.getWidth() - (x + this.m_histBarCounts.length * barWidth)) / 2;
                        }
                        g.drawLine(x, this.getHeight() - 17, barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 17);
                        g.drawLine(x, this.getHeight() - 16, x, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), x, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(x + barWidth * this.m_histBarCounts.length / 2, this.getHeight() - 16, x + barWidth * this.m_histBarCounts.length / 2, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), x + barWidth * this.m_histBarCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        g.drawLine(barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 16, barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - 1 : x + barWidth * this.m_histBarCounts.length, this.getHeight() - 12);
                        g.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), barWidth == 1 ? x + barWidth * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : x + barWidth * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    }
                } else {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    g.drawString("Attribute is neither numeric nor nominal.", this.getWidth() / 2 - this.m_fm.stringWidth("Attribute is neither numeric nor nominal.") / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
                }
            } else if (this.m_displayCurrentAttribute) {
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                g.drawString("Calculating. Please Wait...", this.getWidth() / 2 - this.m_fm.stringWidth("Calculating. Please Wait...") / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
            } else if (!this.m_displayCurrentAttribute) {
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                g.drawString("Too many values to display.", this.getWidth() / 2 - this.m_fm.stringWidth("Too many values to display.") / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            JFrame jf = new JFrame("AttribVisualization");
            AttributeVisualizationPanel ap = new AttributeVisualizationPanel();
            try {
                Instances ins = new Instances(new FileReader(args[0]));
                ap.setInstances(ins);
                System.out.println("Loaded: " + args[0] + "\nRelation: " + ap.m_data.relationName() + "\nAttributes: " + ap.m_data.numAttributes());
                ap.setAttribute(Integer.parseInt(args[1]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            System.out.println("The attributes are: ");
            for (int i = 0; i < ap.m_data.numAttributes(); ++i) {
                System.out.println(ap.m_data.attribute(i).name());
            }
            jf.setSize(500, 300);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)ap, "Center");
            jf.setDefaultCloseOperation(3);
            jf.setVisible(true);
        } else {
            System.out.println("Usage: java AttributeVisualizationPanel [arff file] [index of attribute]");
        }
    }

    private class HistCalc
    extends Thread {
        private HistCalc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    double intervalWidth = 0.0;
                    intervalWidth = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int intervals = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / intervalWidth));
                    if (intervals > AttributeVisualizationPanel.this.getWidth() && (intervals = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        intervals = 1;
                    }
                    double[][] histClassCounts = new double[intervals][AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                    double barRange = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)histClassCounts.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0.0;
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.add(Color.black);
                    }
                    for (int i = AttributeVisualizationPanel.this.m_colorList.size(); i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++i) {
                        Color pc = m_defaultColors[(i - 1) % 10];
                        int ija = (i - 1) / 10;
                        ija *= 2;
                        for (int j = 0; j < ija; ++j) {
                            pc = pc.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.add(pc);
                    }
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        int t = 0;
                        try {
                            if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                            t = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange));
                            if (t == 0) {
                                if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                    double[] dArray = histClassCounts[t];
                                    dArray[0] = dArray[0] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                                    continue;
                                }
                                double[] dArray = histClassCounts[t];
                                int n2 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                                dArray[n2] = dArray[n2] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                                continue;
                            }
                            if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                double[] dArray = histClassCounts[t - 1];
                                dArray[0] = dArray[0] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                                continue;
                            }
                            double[] dArray = histClassCounts[t - 1];
                            int n3 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                            dArray[n3] = dArray[n3] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ae) {
                            System.out.println("t:" + t + " barRange:" + barRange + " histLength:" + histClassCounts.length + " value:" + AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) + " min:" + AttributeVisualizationPanel.this.m_as.numericStats.min + " sumResult:" + (AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) + " divideResult:" + (float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange) + " finalResult:" + Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange)));
                        }
                    }
                    for (double[] histClassCount : histClassCounts) {
                        double sum = 0.0;
                        for (double element : histClassCount) {
                            sum += element;
                        }
                        if (!(AttributeVisualizationPanel.this.m_maxValue < sum)) continue;
                        AttributeVisualizationPanel.this.m_maxValue = sum;
                    }
                    SparseInstance[] histClassCountsSparse = new SparseInstance[histClassCounts.length];
                    for (int i = 0; i < histClassCounts.length; ++i) {
                        SparseInstance tempS;
                        int numSparseValues = 0;
                        for (int j = 0; j < histClassCounts[i].length; ++j) {
                            if (!(histClassCounts[i][j] > 0.0)) continue;
                            ++numSparseValues;
                        }
                        double[] sparseValues = new double[numSparseValues];
                        int[] sparseIndices = new int[numSparseValues];
                        int count = 0;
                        for (int j = 0; j < histClassCounts[i].length; ++j) {
                            if (!(histClassCounts[i][j] > 0.0)) continue;
                            sparseValues[count] = histClassCounts[i][j];
                            sparseIndices[count++] = j;
                        }
                        histClassCountsSparse[i] = tempS = new SparseInstance(1.0, sparseValues, sparseIndices, histClassCounts[i].length);
                    }
                    AttributeVisualizationPanel.this.m_histBarClassCounts = histClassCountsSparse;
                    AttributeVisualizationPanel.this.m_barRange = barRange;
                } else {
                    double intervalWidth = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int intervals = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / intervalWidth));
                    if (intervals > AttributeVisualizationPanel.this.getWidth() && (intervals = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        intervals = 1;
                    }
                    double[] histCounts = new double[intervals];
                    double barRange = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)histCounts.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0.0;
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        int t = 0;
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        try {
                            t = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange));
                            if (t == 0) {
                                int n4 = t;
                                histCounts[n4] = histCounts[n4] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                                if (!(histCounts[t] > AttributeVisualizationPanel.this.m_maxValue)) continue;
                                AttributeVisualizationPanel.this.m_maxValue = histCounts[t];
                                continue;
                            }
                            int n5 = t - 1;
                            histCounts[n5] = histCounts[n5] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                            if (!(histCounts[t - 1] > AttributeVisualizationPanel.this.m_maxValue)) continue;
                            AttributeVisualizationPanel.this.m_maxValue = histCounts[t - 1];
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ae) {
                            ae.printStackTrace();
                            System.out.println("t:" + t + " barRange:" + barRange + " histLength:" + histCounts.length + " value:" + AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) + " min:" + AttributeVisualizationPanel.this.m_as.numericStats.min + " sumResult:" + (AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) + " divideResult:" + (float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange) + " finalResult:" + Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / barRange)));
                        }
                    }
                    AttributeVisualizationPanel.this.m_histBarCounts = histCounts;
                    AttributeVisualizationPanel.this.m_barRange = barRange;
                }
                AttributeVisualizationPanel.this.m_threadRun = false;
                AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                AttributeVisualizationPanel.this.repaint();
            }
        }
    }

    private class BarCalc
    extends Thread {
        private final int m_panelWidth;

        public BarCalc(int panelWidth, int panelHeight) {
            this.m_panelWidth = panelWidth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues() > this.m_panelWidth) {
                    AttributeVisualizationPanel.this.m_histBarClassCounts = null;
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = false;
                    AttributeVisualizationPanel.this.repaint();
                    return;
                }
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    int i;
                    SparseInstance[] histClassCounts = new SparseInstance[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()];
                    if (AttributeVisualizationPanel.this.m_as.nominalWeights.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalWeights[0];
                        for (i = 0; i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++i) {
                            if (!(AttributeVisualizationPanel.this.m_as.nominalWeights[i] > AttributeVisualizationPanel.this.m_maxValue)) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalWeights[i];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0.0;
                    }
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.add(Color.black);
                    }
                    for (i = AttributeVisualizationPanel.this.m_colorList.size(); i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++i) {
                        Color pc = m_defaultColors[(i - 1) % 10];
                        int ija = (i - 1) / 10;
                        ija *= 2;
                        for (int j = 0; j < ija; ++j) {
                            pc = pc.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.add(pc);
                    }
                    AttributeVisualizationPanel.this.m_data.sort(AttributeVisualizationPanel.this.m_attribIndex);
                    double[] tempClassCounts = null;
                    int tempAttValueIndex = -1;
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        if (AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex) != (double)tempAttValueIndex) {
                            if (tempClassCounts != null) {
                                SparseInstance tempS;
                                int numNonZero = 0;
                                for (double tempClassCount : tempClassCounts) {
                                    if (!(tempClassCount > 0.0)) continue;
                                    ++numNonZero;
                                }
                                double[] nonZeroVals = new double[numNonZero];
                                int[] nonZeroIndices = new int[numNonZero];
                                int n2 = 0;
                                for (int z = 0; z < tempClassCounts.length; ++z) {
                                    if (!(tempClassCounts[z] > 0.0)) continue;
                                    nonZeroVals[n2] = tempClassCounts[z];
                                    nonZeroIndices[n2++] = z;
                                }
                                histClassCounts[tempAttValueIndex] = tempS = new SparseInstance(1.0, nonZeroVals, nonZeroIndices, tempClassCounts.length);
                            }
                            tempClassCounts = new double[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                            tempAttValueIndex = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex);
                        }
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                            tempClassCounts[0] = tempClassCounts[0] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                            continue;
                        }
                        int n3 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                        tempClassCounts[n3] = tempClassCounts[n3] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                    }
                    if (tempClassCounts != null) {
                        SparseInstance sparseInstance;
                        void var9_22;
                        int numNonZero = 0;
                        for (void var9_20 : tempClassCounts) {
                            if (!(var9_20 > 0.0)) continue;
                            ++numNonZero;
                        }
                        double[] nonZeroVals = new double[numNonZero];
                        int[] nonZeroIndices = new int[numNonZero];
                        int count = 0;
                        boolean bl = false;
                        while (var9_22 < tempClassCounts.length) {
                            if (tempClassCounts[var9_22] > 0.0) {
                                nonZeroVals[count] = tempClassCounts[var9_22];
                                nonZeroIndices[count++] = var9_22;
                            }
                            ++var9_22;
                        }
                        histClassCounts[tempAttValueIndex] = sparseInstance = new SparseInstance(1.0, nonZeroVals, nonZeroIndices, tempClassCounts.length);
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_histBarClassCounts = histClassCounts;
                    AttributeVisualizationPanel.this.repaint();
                } else {
                    double[] histCounts = new double[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()];
                    if (AttributeVisualizationPanel.this.m_as.nominalWeights.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalWeights[0];
                        for (int i = 0; i < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++i) {
                            if (!(AttributeVisualizationPanel.this.m_as.nominalWeights[i] > AttributeVisualizationPanel.this.m_maxValue)) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalWeights[i];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0.0;
                    }
                    for (int k = 0; k < AttributeVisualizationPanel.this.m_data.numInstances(); ++k) {
                        if (AttributeVisualizationPanel.this.m_data.instance(k).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        int n4 = (int)AttributeVisualizationPanel.this.m_data.instance(k).value(AttributeVisualizationPanel.this.m_attribIndex);
                        histCounts[n4] = histCounts[n4] + AttributeVisualizationPanel.this.m_data.instance(k).weight();
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_displayCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_doneCurrentAttribute = true;
                    AttributeVisualizationPanel.this.m_histBarCounts = histCounts;
                    AttributeVisualizationPanel.this.repaint();
                }
            }
        }
    }
}

