/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.Map;
import org.activiti.crystalball.simulator.AbstractSimulationRun;
import org.activiti.crystalball.simulator.EventCalendar;
import org.activiti.crystalball.simulator.SimpleEventCalendar;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventComparator;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.runtime.ClockReader;

public class ReplaySimulationRun
extends AbstractSimulationRun {
    private final EventCalendar eventCalendar;

    public ReplaySimulationRun(ProcessEngine processEngine, Map<String, SimulationEventHandler> customEventHandlerMap) {
        this(processEngine, new SimpleEventCalendar((ClockReader)processEngine.getProcessEngineConfiguration().getClock(), new SimulationEventComparator()), customEventHandlerMap);
    }

    public ReplaySimulationRun(ProcessEngine processEngine, EventCalendar eventCalendar, Map<String, SimulationEventHandler> customEventHandlerMap) {
        super(customEventHandlerMap);
        this.processEngine = processEngine;
        this.eventCalendar = eventCalendar;
    }

    @Override
    protected void initSimulationRunContext(VariableScope execution) {
        SimulationRunContext.setEventCalendar(this.eventCalendar);
        SimulationRunContext.setProcessEngine(this.processEngine);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        SimulationRunContext.setSimulationRunId(configuration.getIdGenerator().getNextId());
    }

    @Override
    protected boolean simulationEnd(SimulationEvent event) {
        return false;
    }

    @Override
    public void close() {
        SimulationRunContext.getEventCalendar().clear();
        SimulationRunContext.removeEventCalendar();
        SimulationRunContext.removeProcessEngine();
    }
}

