/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.Stack;
import org.activiti.crystalball.simulator.EventCalendar;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.runtime.Clock;

public abstract class SimulationRunContext {
    protected static ThreadLocal<Stack<ProcessEngine>> processEngineThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<EventCalendar>> eventCalendarThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<String>> simulationRunIdThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<VariableScope>> executionThreadLocal = new ThreadLocal();

    public static RuntimeService getRuntimeService() {
        Stack stack = SimulationRunContext.getStack(processEngineThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return ((ProcessEngine)stack.peek()).getRuntimeService();
    }

    public static void setProcessEngine(ProcessEngine processEngine) {
        SimulationRunContext.getStack(processEngineThreadLocal).push(processEngine);
    }

    public static ProcessEngine getProcessEngine() {
        return (ProcessEngine)SimulationRunContext.getStack(processEngineThreadLocal).peek();
    }

    public static void removeProcessEngine() {
        SimulationRunContext.getStack(processEngineThreadLocal).pop();
    }

    public static TaskService getTaskService() {
        Stack stack = SimulationRunContext.getStack(processEngineThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return ((ProcessEngine)stack.peek()).getTaskService();
    }

    public static EventCalendar getEventCalendar() {
        Stack stack = SimulationRunContext.getStack(eventCalendarThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (EventCalendar)stack.peek();
    }

    public static void setEventCalendar(EventCalendar eventCalendar) {
        SimulationRunContext.getStack(eventCalendarThreadLocal).push(eventCalendar);
    }

    public static String getSimulationRunId() {
        Stack stack = SimulationRunContext.getStack(simulationRunIdThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (String)stack.peek();
    }

    public static void setSimulationRunId(String simulationRunId) {
        SimulationRunContext.getStack(simulationRunIdThreadLocal).push(simulationRunId);
    }

    public static void removeEventCalendar() {
        SimulationRunContext.getStack(eventCalendarThreadLocal).pop();
    }

    public static HistoryService getHistoryService() {
        Stack stack = SimulationRunContext.getStack(processEngineThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return ((ProcessEngine)stack.peek()).getHistoryService();
    }

    public static RepositoryService getRepositoryService() {
        Stack stack = SimulationRunContext.getStack(processEngineThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return ((ProcessEngine)stack.peek()).getRepositoryService();
    }

    public static VariableScope getExecution() {
        Stack stack = SimulationRunContext.getStack(executionThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (VariableScope)stack.peek();
    }

    public static void setExecution(VariableScope execution) {
        SimulationRunContext.getStack(executionThreadLocal).push(execution);
    }

    public static Clock getClock() {
        return SimulationRunContext.getProcessEngine().getProcessEngineConfiguration().getClock();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

