/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.delegate.event.impl;

import java.util.HashMap;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.delegate.event.impl.Activiti2SimulationEventFunction;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.ProcessInstance;

public class ProcessInstanceCreateTransformer
extends Activiti2SimulationEventFunction {
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    private final String processDefinitionIdKey;
    private final String businessKey;
    private final String variablesKey;

    public ProcessInstanceCreateTransformer(String simulationEventType, String processDefinitionIdKey, String businessKey, String variablesKey) {
        super(simulationEventType);
        this.processDefinitionIdKey = processDefinitionIdKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public SimulationEvent apply(ActivitiEvent event) {
        if (ActivitiEventType.ENTITY_INITIALIZED.equals((Object)event.getType()) && event instanceof ActivitiEntityEvent && ((ActivitiEntityEvent)event).getEntity() instanceof ProcessInstance && ((ExecutionEntity)((ActivitiEntityEvent)event).getEntity()).isProcessInstanceType()) {
            ProcessInstance processInstance = (ProcessInstance)((ActivitiEntityEvent)event).getEntity();
            ExecutionEntity executionEntity = (ExecutionEntity)((ActivitiEntityEvent)event).getEntity();
            HashMap<String, Object> simEventProperties = new HashMap<String, Object>();
            simEventProperties.put(this.processDefinitionIdKey, processInstance.getProcessDefinitionId());
            simEventProperties.put(this.businessKey, processInstance.getBusinessKey());
            simEventProperties.put(this.variablesKey, executionEntity.getVariables());
            simEventProperties.put(PROCESS_INSTANCE_ID, executionEntity.getProcessInstanceId());
            return new SimulationEvent.Builder(this.simulationEventType).simulationTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime().getTime()).properties(simEventProperties).build();
        }
        return null;
    }
}

